/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.input;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.logging.LogManager;
import omegadrive.input.jinput.JinputGamepadInputProvider;
import omegadrive.joypad.JoypadProvider;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import org.slf4j.Logger;

public interface InputProvider {
    public static final Logger LOG = LogHelper.getLogger(InputProvider.class.getSimpleName());
    public static final String KEYBOARD_CONTROLLER = "Default (Keyboard)";
    public static final String NO_CONTROLLER = "Disable";
    public static final List<String> DEFAULT_CONTROLLERS = ImmutableList.of((Object)"Disable", (Object)"Default (Keyboard)");
    public static final boolean DEBUG_DETECTION = Boolean.parseBoolean(System.getProperty("jinput.detect.debug", "false"));
    public static final boolean JINPUT_ENABLE = Boolean.parseBoolean(System.getProperty("jinput.enable", "false"));
    public static final String JINPUT_NATIVES_PATH = System.getProperty("jinput.native.location", "lib");
    public static final InputProvider NO_OP = new InputProvider(){

        @Override
        public void handleEvents() {
        }

        @Override
        public void handleAllEvents(InputEventCallback callback) {
        }

        @Override
        public void setPlayerController(PlayerNumber player, String controllerName) {
        }

        @Override
        public void reset() {
        }

        @Override
        public List<String> getAvailableControllers() {
            return DEFAULT_CONTROLLERS;
        }
    };
    public static final float ON = 1.0f;

    public static InputProvider createInstance(JoypadProvider joypadProvider) {
        InputProvider ip = NO_OP;
        if (JINPUT_ENABLE) {
            try {
                ip = JinputGamepadInputProvider.getInstance(joypadProvider);
            }
            catch (Error | Exception e) {
                LOG.warn("Unable to load jinput: {}: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            }
        }
        return ip;
    }

    public static void bootstrap() {
        String lib = new File(".").getAbsolutePath() + File.separator + JINPUT_NATIVES_PATH + File.separator + Util.NATIVE_SUBDIR;
        System.setProperty("net.java.games.input.librarypath", lib);
        LOG.info("Loading system library from: {}", (Object)lib);
        LogManager.getLogManager().reset();
        LOG.info("Disabling java.util.logging");
    }

    public void handleEvents();

    public void handleAllEvents(InputEventCallback var1);

    public void setPlayerController(PlayerNumber var1, String var2);

    public void reset();

    public List<String> getAvailableControllers();

    public static interface InputEventCallback {
        public void update(Object var1);
    }

    public static enum PlayerNumber {
        P1,
        P2;

    }
}

