/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.input;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import omegadrive.SystemLoader;
import omegadrive.input.ColecoKeyboardInput;
import omegadrive.input.InputProvider;
import omegadrive.input.KeyboardInputHelper;
import omegadrive.input.MsxKeyboardInput;
import omegadrive.joypad.JoypadProvider;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public class KeyboardInput
extends KeyAdapter {
    protected static final Logger LOG = LogHelper.getLogger(KeyboardInput.class.getSimpleName());
    protected JoypadProvider provider;
    protected SystemLoader.SystemType systemType;

    @Override
    public void keyPressed(KeyEvent e) {
        KeyboardInput.keyHandler(this.provider, e, true);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        KeyboardInput.keyHandler(this.provider, e, false);
    }

    public static KeyAdapter createKeyAdapter(SystemLoader.SystemType systemType, JoypadProvider provider) {
        Objects.requireNonNull(provider);
        Objects.requireNonNull(systemType);
        KeyboardInput res = null;
        switch (systemType) {
            case COLECO: {
                res = new ColecoKeyboardInput();
                break;
            }
            case MSX: {
                res = new MsxKeyboardInput();
                break;
            }
            default: {
                res = new KeyboardInput();
            }
        }
        res.provider = provider;
        LOG.info("Setting keyAdapter for {}", (Object)systemType);
        return res;
    }

    protected static void keyHandler(JoypadProvider joypad, KeyEvent e, boolean pressed) {
        JoypadProvider.JoypadAction action = pressed ? JoypadProvider.JoypadAction.PRESSED : JoypadProvider.JoypadAction.RELEASED;
        int kc = e.getKeyCode();
        Optional optEntry = KeyboardInputHelper.keyboardInverseBindings.column((Object)kc).entrySet().stream().findFirst();
        if (e.getModifiers() == 0 && optEntry.isPresent()) {
            joypad.setButtonAction((InputProvider.PlayerNumber)((Object)((Map.Entry)optEntry.get()).getKey()), (JoypadProvider.JoypadButton)((Object)((Map.Entry)optEntry.get()).getValue()), action, e);
        } else if (optEntry.isPresent()) {
            if (!pressed) {
                joypad.setButtonAction((InputProvider.PlayerNumber)((Object)((Map.Entry)optEntry.get()).getKey()), (JoypadProvider.JoypadButton)((Object)((Map.Entry)optEntry.get()).getValue()), action, e);
            }
        } else {
            LOG.debug("Ignored event: {}, pressed: {}", (Object)e, (Object)pressed);
        }
    }
}

