/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.input;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import omegadrive.input.InputProvider;
import omegadrive.joypad.JoypadProvider;
import omegadrive.system.SystemProvider;
import omegadrive.ui.KeyBindingsHandler;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public class KeyboardInputHelper {
    public static final Map<String, Integer> DEFAULT_P1_KEY_BINDINGS = ImmutableMap.builder().put((Object)JoypadProvider.JoypadButton.U.name(), (Object)38).put((Object)JoypadProvider.JoypadButton.D.name(), (Object)40).put((Object)JoypadProvider.JoypadButton.L.name(), (Object)37).put((Object)JoypadProvider.JoypadButton.R.name(), (Object)39).put((Object)JoypadProvider.JoypadButton.A.name(), (Object)73).put((Object)JoypadProvider.JoypadButton.B.name(), (Object)79).put((Object)JoypadProvider.JoypadButton.C.name(), (Object)80).put((Object)JoypadProvider.JoypadButton.M.name(), (Object)76).put((Object)JoypadProvider.JoypadButton.S.name(), (Object)10).build();
    public static final Map<String, Integer> DEFAULT_P2_KEY_BINDINGS = ImmutableMap.builder().put((Object)JoypadProvider.JoypadButton.U.name(), (Object)84).put((Object)JoypadProvider.JoypadButton.D.name(), (Object)71).put((Object)JoypadProvider.JoypadButton.L.name(), (Object)70).put((Object)JoypadProvider.JoypadButton.R.name(), (Object)71).put((Object)JoypadProvider.JoypadButton.A.name(), (Object)67).put((Object)JoypadProvider.JoypadButton.B.name(), (Object)86).put((Object)JoypadProvider.JoypadButton.C.name(), (Object)66).put((Object)JoypadProvider.JoypadButton.M.name(), (Object)78).put((Object)JoypadProvider.JoypadButton.S.name(), (Object)32).build();
    public static final Table<InputProvider.PlayerNumber, String, Integer> keyboardStringBindings = HashBasedTable.create();
    public static final Table<InputProvider.PlayerNumber, Integer, String> keyboardInverseStringBindings = HashBasedTable.create();
    public static final Table<InputProvider.PlayerNumber, Integer, JoypadProvider.JoypadButton> keyboardInverseBindings = HashBasedTable.create();
    public static final Table<InputProvider.PlayerNumber, JoypadProvider.JoypadButton, Integer> keyboardBindings = HashBasedTable.create();
    public static final InputMap DEFAULT_INPUT_MAP = new InputMap();
    protected static final Logger LOG = LogHelper.getLogger(KeyboardInputHelper.class.getSimpleName());

    public static void init() {
    }

    public static void updatePlayerMappings(InputProvider.PlayerNumber number, Map<String, Integer> map) {
        keyboardStringBindings.row((Object)number).clear();
        keyboardInverseStringBindings.row((Object)number).clear();
        keyboardInverseBindings.row((Object)number).clear();
        keyboardBindings.row((Object)number).clear();
        map.forEach((key, value) -> {
            keyboardStringBindings.put((Object)number, key, value);
            keyboardInverseStringBindings.put((Object)number, value, key);
            keyboardInverseBindings.put((Object)number, value, (Object)JoypadProvider.JoypadButton.valueOf(key));
            keyboardBindings.put((Object)number, (Object)JoypadProvider.JoypadButton.valueOf(key), value);
        });
        KeyboardInputHelper.consistencyCheck(number);
    }

    private static void consistencyCheck(InputProvider.PlayerNumber number) {
        TreeSet pSet = new TreeSet(keyboardBindings.row((Object)number).values());
        for (InputProvider.PlayerNumber pn : InputProvider.PlayerNumber.values()) {
            TreeSet pSet2;
            Sets.SetView s;
            if (pn == number || (s = Sets.intersection(pSet, pSet2 = new TreeSet(keyboardBindings.row((Object)pn).values()))).isEmpty()) continue;
            LOG.error("Illegal controller setup, {} vs {}", (Object)number, (Object)pn);
            for (Integer key : s) {
                KeyStroke ks = KeyStroke.getKeyStroke((char)key.intValue());
                LOG.error("{}  button {}->{}, {} button {}->{}", new Object[]{number, ((JoypadProvider.JoypadButton)((Object)keyboardInverseBindings.get((Object)number, (Object)key))).getMnemonic(), ks, pn, ((JoypadProvider.JoypadButton)((Object)keyboardInverseBindings.get((Object)pn, (Object)key))).getMnemonic(), ks});
            }
        }
    }

    static {
        DEFAULT_INPUT_MAP.put(KeyStroke.getKeyStroke(10, 512), (Object)SystemProvider.SystemEvent.TOGGLE_FULL_SCREEN);
        DEFAULT_INPUT_MAP.put(KeyStroke.getKeyStroke(84, 128), (Object)SystemProvider.SystemEvent.TOGGLE_THROTTLE);
        DEFAULT_INPUT_MAP.put(KeyStroke.getKeyStroke(68, 128), (Object)SystemProvider.SystemEvent.SHOW_FPS);
        DEFAULT_INPUT_MAP.put(KeyStroke.getKeyStroke(80, 128), (Object)SystemProvider.SystemEvent.TOGGLE_PAUSE);
        DEFAULT_INPUT_MAP.put(KeyStroke.getKeyStroke(77, 128), (Object)SystemProvider.SystemEvent.SOUND_ENABLED);
        DEFAULT_INPUT_MAP.put(KeyStroke.getKeyStroke(82, 128), (Object)SystemProvider.SystemEvent.RESET);
        DEFAULT_INPUT_MAP.put(KeyStroke.getKeyStroke(82, 192), (Object)SystemProvider.SystemEvent.SOFT_RESET);
        DEFAULT_INPUT_MAP.put(KeyStroke.getKeyStroke(57, 128), (Object)SystemProvider.SystemEvent.QUICK_LOAD);
        DEFAULT_INPUT_MAP.put(KeyStroke.getKeyStroke(49, 128), (Object)SystemProvider.SystemEvent.QUICK_SAVE);
        DEFAULT_INPUT_MAP.put(KeyStroke.getKeyStroke(55, 128), (Object)SystemProvider.SystemEvent.LOAD_STATE);
        DEFAULT_INPUT_MAP.put(KeyStroke.getKeyStroke(54, 128), (Object)SystemProvider.SystemEvent.SAVE_STATE);
        DEFAULT_INPUT_MAP.put(KeyStroke.getKeyStroke(76, 128), (Object)SystemProvider.SystemEvent.NEW_ROM);
        DEFAULT_INPUT_MAP.put(KeyStroke.getKeyStroke(27, 128), (Object)SystemProvider.SystemEvent.CLOSE_ROM);
        DEFAULT_INPUT_MAP.put(KeyStroke.getKeyStroke(83, 192), (Object)SystemProvider.SystemEvent.TOGGLE_SOUND_RECORD);
        DEFAULT_INPUT_MAP.put(KeyStroke.getKeyStroke(27, 192), (Object)SystemProvider.SystemEvent.CLOSE_APP);
        KeyboardInputHelper.updatePlayerMappings(InputProvider.PlayerNumber.P1, DEFAULT_P1_KEY_BINDINGS);
        KeyboardInputHelper.updatePlayerMappings(InputProvider.PlayerNumber.P2, DEFAULT_P2_KEY_BINDINGS);
        KeyBindingsHandler.getInstance();
    }
}

