/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.input;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import omegadrive.input.KeyboardInput;
import omegadrive.util.Util;

public class MsxKeyboardInput
extends KeyboardInput {
    protected static MsxKeyboardInput currentAdapter;
    private final byte[] rows = new byte[11];
    private final int[][] charMatrix = new int[][]{{48, 0, 0}, {41, 0, 0}, {49, 0, 1}, {33, 0, 1}, {50, 0, 2}, {64, 0, 2}, {51, 0, 3}, {35, 0, 3}, {52, 0, 4}, {36, 0, 4}, {53, 0, 5}, {37, 0, 5}, {54, 0, 6}, {38, 0, 6}, {55, 0, 7}, {39, 0, 7}, {56, 1, 0}, {42, 1, 0}, {57, 1, 1}, {40, 1, 1}, {45, 1, 2}, {95, 1, 2}, {61, 1, 3}, {43, 1, 3}, {92, 1, 4}, {124, 1, 4}, {91, 1, 5}, {123, 1, 5}, {93, 1, 6}, {125, 1, 6}, {59, 1, 7}, {58, 1, 7}, {65, 2, 6}, {66, 2, 7}, {97, 2, 6}, {98, 2, 7}, {47, 2, 4}, {63, 2, 4}, {46, 2, 3}, {62, 2, 3}, {44, 2, 2}, {60, 2, 2}, {96, 2, 1}, {126, 2, 1}, {39, 2, 0}, {34, 2, 0}, {67, 3, 0}, {68, 3, 1}, {69, 3, 2}, {70, 3, 3}, {71, 3, 4}, {72, 3, 5}, {73, 3, 6}, {74, 3, 7}, {99, 3, 0}, {100, 3, 1}, {101, 3, 2}, {102, 3, 3}, {103, 3, 4}, {104, 3, 5}, {105, 3, 6}, {106, 3, 7}, {75, 4, 0}, {76, 4, 1}, {77, 4, 2}, {78, 4, 3}, {79, 4, 4}, {80, 4, 5}, {81, 4, 6}, {82, 4, 7}, {107, 4, 0}, {108, 4, 1}, {109, 4, 2}, {110, 4, 3}, {111, 4, 4}, {112, 4, 5}, {113, 4, 6}, {114, 4, 7}, {83, 5, 0}, {84, 5, 1}, {85, 5, 2}, {86, 5, 3}, {87, 5, 4}, {88, 5, 5}, {89, 5, 6}, {90, 5, 7}, {115, 5, 0}, {116, 5, 1}, {117, 5, 2}, {118, 5, 3}, {119, 5, 4}, {120, 5, 5}, {121, 5, 6}, {122, 5, 7}};
    private final int[][] keyMatrix = new int[][]{{16, 6, 0}, {17, 6, 1}, {65406, 6, 2}, {20, 6, 3}, {258, 6, 4}, {112, 6, 5}, {113, 6, 6}, {114, 6, 7}, {115, 7, 0}, {116, 7, 1}, {27, 7, 2}, {9, 7, 3}, {65480, 7, 4}, {8, 7, 5}, {117, 7, 6}, {10, 7, 7}, {32, 8, 0}, {36, 8, 1}, {155, 8, 2}, {127, 8, 3}, {37, 8, 4}, {38, 8, 5}, {40, 8, 6}, {39, 8, 7}};

    public MsxKeyboardInput() {
        currentAdapter = this;
    }

    public static MsxKeyboardInput getMsxKeyAdapter() {
        return currentAdapter;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.processKeyEvent(e, true);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.processKeyEvent(e, false);
    }

    public void stopKeyPressed() {
        this.pressKey(7, 4);
    }

    public void stopKeyDepressed() {
        this.depressKey(7, 4);
    }

    private void processKeyEvent(KeyEvent e, boolean state) {
        char c = e.getKeyChar();
        boolean success = false;
        for (int i = 0; i < this.charMatrix.length; ++i) {
            if (c != this.charMatrix[i][0]) continue;
            if (state) {
                this.pressKey(this.charMatrix[i][1], this.charMatrix[i][2]);
            } else {
                this.depressKey(this.charMatrix[i][1], this.charMatrix[i][2]);
            }
            success = true;
            break;
        }
        if (!success) {
            int k = e.getKeyCode();
            for (int i = 0; i < this.keyMatrix.length; ++i) {
                if (k != this.keyMatrix[i][0]) continue;
                if (state) {
                    this.pressKey(this.keyMatrix[i][1], this.keyMatrix[i][2]);
                    continue;
                }
                this.depressKey(this.keyMatrix[i][1], this.keyMatrix[i][2]);
            }
        }
    }

    private void pressKey(int row, int bit) {
        this.rows[row] = (byte)(this.rows[row] & 0xFF | 1 << bit);
    }

    private void depressKey(int row, int bit) {
        this.rows[row] = (byte)Util.setBit(this.rows[row] & 0xFF, bit, 0);
    }

    public byte getRowValue(int row) {
        return this.rows[row];
    }

    public void setCapslock(boolean state) {
        if (state != Toolkit.getDefaultToolkit().getLockingKeyState(20)) {
            Toolkit.getDefaultToolkit().setLockingKeyState(20, state);
        }
    }
}

