/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.joypad;

import java.awt.event.KeyEvent;
import omegadrive.Device;
import omegadrive.input.InputProvider;

public interface JoypadProvider
extends Device {
    public static final JoypadButton[] directionButton = new JoypadButton[]{JoypadButton.D, JoypadButton.L, JoypadButton.R, JoypadButton.U};

    public void setButtonAction(InputProvider.PlayerNumber var1, JoypadButton var2, JoypadAction var3);

    public boolean hasDirectionPressed(InputProvider.PlayerNumber var1);

    public String getState(InputProvider.PlayerNumber var1);

    public void newFrame();

    default public void setButtonAction(InputProvider.PlayerNumber number, JoypadButton button, JoypadAction action, KeyEvent event) {
        this.setButtonAction(number, button, action);
    }

    default public void setPadSetupChange(InputProvider.PlayerNumber playerNumber, String info) {
    }

    public static enum JoypadButton {
        A,
        B,
        C,
        X,
        Y,
        Z,
        M("MODE"),
        S("START"),
        U("UP"),
        D("DOWN"),
        L("LEFT"),
        R("RIGHT"),
        K0,
        K1,
        K2,
        K3,
        K4,
        K5,
        K6,
        K7,
        K8,
        K9,
        K_AST,
        K_HASH;

        public static final JoypadButton[] vals;
        final String mnemonic;

        private JoypadButton() {
            this.mnemonic = this.name();
        }

        private JoypadButton(String s) {
            this.mnemonic = s;
        }

        public String getMnemonic() {
            return this.mnemonic;
        }

        public boolean isDirection() {
            return D == this || U == this || R == this || L == this;
        }

        static {
            vals = JoypadButton.values();
        }
    }

    public static enum JoypadAction {
        PRESSED,
        RELEASED;

    }

    public static enum JoypadDirection {
        UP_DOWN(JoypadButton.U, JoypadButton.D),
        LEFT_RIGHT(JoypadButton.L, JoypadButton.R);

        final JoypadButton b1;
        final JoypadButton b2;

        private JoypadDirection(JoypadButton b1, JoypadButton b2) {
            this.b1 = b1;
            this.b2 = b2;
        }
    }

    public static enum JoypadType {
        NONE,
        BUTTON_2,
        BUTTON_3,
        BUTTON_6;

    }
}

