/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.joypad;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import omegadrive.input.InputProvider;
import omegadrive.joypad.BasePadAdapter;
import omegadrive.joypad.JoypadProvider;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public class MsxPad
extends BasePadAdapter {
    private static final Logger LOG = LogHelper.getLogger(MsxPad.class.getSimpleName());

    @Override
    public void init() {
        this.p1Type = JoypadProvider.JoypadType.BUTTON_2;
        this.p2Type = JoypadProvider.JoypadType.BUTTON_2;
        LOG.info("Joypad1: {} - Joypad2: {}", (Object)this.p1Type, (Object)this.p2Type);
        this.stateMap1 = Maps.newHashMap((Map)ImmutableMap.builder().put((Object)JoypadProvider.JoypadButton.D, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.U, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.L, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.R, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.A, (Object)JoypadProvider.JoypadAction.RELEASED).put((Object)JoypadProvider.JoypadButton.B, (Object)JoypadProvider.JoypadAction.RELEASED).build());
        this.stateMap2 = Maps.newHashMap((Map)this.stateMap1);
    }

    private int getData(InputProvider.PlayerNumber number) {
        return 0x40 | this.getValue(number, JoypadProvider.JoypadButton.B) << 5 | this.getValue(number, JoypadProvider.JoypadButton.A) << 4 | this.getValue(number, JoypadProvider.JoypadButton.R) << 3 | this.getValue(number, JoypadProvider.JoypadButton.L) << 2 | this.getValue(number, JoypadProvider.JoypadButton.D) << 1 | this.getValue(number, JoypadProvider.JoypadButton.U);
    }

    public int readDataRegister1() {
        return this.value1;
    }

    public int readDataRegister2() {
        return this.value2;
    }

    @Override
    public void newFrame() {
        this.value1 = this.getData(InputProvider.PlayerNumber.P1);
        this.value2 = this.getData(InputProvider.PlayerNumber.P2);
    }
}

