/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.savestate;

public enum MekaSavestateVersion {
    VER_B_OR_EARLIER(-1, 11, 7, 99),
    VER_C(0, 12, 11, 103),
    VER_D(0, 13, 11, 105),
    VER_E_OR_LATER(1, 14, 11, 105);

    public static final int VERSION_POS = 5;
    public static final int CRC_POS = 7;
    static final int EQ = 0;
    static final int LESS = -1;
    static final int MORE = 1;
    private final int endHeaderPos;
    private final int memoryStartPos;
    private final int version;
    private final int orderToken;

    private MekaSavestateVersion(int orderToken, int version, int endHeaderPos, int memoryStartPos) {
        this.endHeaderPos = endHeaderPos;
        this.orderToken = orderToken;
        this.version = version;
        this.memoryStartPos = memoryStartPos;
    }

    public static MekaSavestateVersion getMekaVersion(int version) {
        for (MekaSavestateVersion v : MekaSavestateVersion.values()) {
            if (v.orderToken != 0 || v.version != version) continue;
            return v;
        }
        for (MekaSavestateVersion v : MekaSavestateVersion.values()) {
            boolean match;
            if (v.orderToken == 0) continue;
            boolean bl = v.orderToken > 0 ? version >= v.version : (match = version <= v.version);
            if (!match) continue;
            return v;
        }
        return null;
    }

    public int getEndHeaderPos() {
        return this.endHeaderPos;
    }

    public int getMemoryStartPos() {
        return this.memoryStartPos;
    }

    public int getMemoryEndPos() {
        return this.memoryStartPos + 24608;
    }

    public int getVersion() {
        return this.version;
    }
}

