/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.savestate;

import com.google.common.collect.ImmutableSet;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import omegadrive.Device;
import omegadrive.SystemLoader;
import omegadrive.bus.z80.MsxBus;
import omegadrive.cpu.z80.Z80Provider;
import omegadrive.memory.IMemoryProvider;
import omegadrive.savestate.BaseStateHandler;
import omegadrive.savestate.StateUtil;
import omegadrive.util.FileUtil;
import omegadrive.util.LogHelper;
import omegadrive.vdp.Tms9918aVdp;
import org.slf4j.Logger;

public class Z80StateBaseHandler
implements BaseStateHandler {
    protected static final Z80SavestateVersion CURRENT_SAVE_VERSION = Z80SavestateVersion.VER_1;
    private static final Logger LOG = LogHelper.getLogger(Z80StateBaseHandler.class.getSimpleName());
    private static final String MAGIC_WORD_STR = "HELIOS-Z80";
    private static final byte[] MAGIC_WORD = "HELIOS-Z80".getBytes();
    private static final int SYS_NAME_LEN = 16;
    private static final Set<Class<? extends Device>> deviceClassSet = ImmutableSet.of(Z80Provider.class, Tms9918aVdp.class, IMemoryProvider.class, MsxBus.class);
    protected String fileExtension = "error";
    protected ByteBuffer buffer;
    protected int version;
    protected String fileName;
    protected BaseStateHandler.Type type;
    protected int FIXED_SIZE_LIMIT = 20480;
    private List<Device> deviceList = Collections.emptyList();

    protected Z80StateBaseHandler() {
    }

    public static BaseStateHandler createInstance(String fileName, SystemLoader.SystemType systemType, BaseStateHandler.Type loadSaveType, Set<Device> devices) {
        return Z80StateBaseHandler.createInstance(fileName, systemType, loadSaveType, devices, null);
    }

    private static BaseStateHandler createInstance(String fileName, SystemLoader.SystemType systemType, BaseStateHandler.Type loadSaveType, Set<Device> devices, byte[] data) {
        Z80StateBaseHandler h;
        switch (systemType) {
            case SG_1000: 
            case COLECO: {
                h = new Z80StateBaseHandler();
                break;
            }
            case MSX: {
                h = new Z80StateBaseHandler();
                h.FIXED_SIZE_LIMIT = 36864;
                break;
            }
            default: {
                LOG.error("Error");
                return BaseStateHandler.EMPTY_STATE;
            }
        }
        if (loadSaveType == BaseStateHandler.Type.LOAD) {
            boolean res = h.initLoadType(fileName, systemType, data);
            if (!res) {
                return BaseStateHandler.EMPTY_STATE;
            }
        } else {
            h.initSaveType(fileName, systemType);
        }
        h.setDevicesWithContext(devices);
        return h;
    }

    public static BaseStateHandler createLoadInstance(String fileName, SystemLoader.SystemType systemType, byte[] data, Set<Device> devices) {
        return Z80StateBaseHandler.createInstance(fileName, systemType, BaseStateHandler.Type.LOAD, devices, data);
    }

    protected String initCommon(String fileName, SystemLoader.SystemType systemType) {
        this.fileExtension = StateUtil.fileExtensionMap.getOrDefault((Object)systemType, "error");
        this.fileName = this.handleFileExtension(fileName);
        return this.fileName;
    }

    protected void initSaveType(String fileName, SystemLoader.SystemType systemType) {
        this.initCommon(fileName, systemType);
        this.buffer = ByteBuffer.allocate(this.FIXED_SIZE_LIMIT);
        this.buffer.put(MAGIC_WORD);
        this.buffer.put((byte)CURRENT_SAVE_VERSION.getVersion());
        this.buffer.put(Arrays.copyOf(systemType.name().getBytes(), 16));
        this.buffer.put(this.FIXED_SIZE_LIMIT - 3, (byte)69);
        this.buffer.put(this.FIXED_SIZE_LIMIT - 2, (byte)79);
        this.buffer.put(this.FIXED_SIZE_LIMIT - 1, (byte)70);
        this.version = CURRENT_SAVE_VERSION.getVersion();
        this.type = BaseStateHandler.Type.SAVE;
    }

    protected boolean initLoadType(String fileName, SystemLoader.SystemType systemType, byte[] data) {
        fileName = this.initCommon(fileName, systemType);
        data = data == null ? FileUtil.readFileSafe(Paths.get(fileName, new String[0])) : data;
        this.buffer = ByteBuffer.wrap(data);
        this.type = BaseStateHandler.Type.LOAD;
        return this.detectStateFileType(systemType);
    }

    private String handleFileExtension(String fileName) {
        return fileName + (String)(!fileName.toLowerCase().contains("." + this.fileExtension) ? "." + this.fileExtension : "");
    }

    protected boolean detectStateFileType(SystemLoader.SystemType systemType) {
        byte[] b = new byte[MAGIC_WORD.length];
        this.buffer.get(b);
        String fileType = new String(b);
        if (!MAGIC_WORD_STR.equalsIgnoreCase(fileType)) {
            LOG.error("Unable to load savestate of type: {}, size: {}", (Object)fileType, (Object)this.buffer.capacity());
            return false;
        }
        this.version = this.buffer.get();
        Z80SavestateVersion pmVersion = Z80SavestateVersion.parseVersion(this.version);
        if (pmVersion != CURRENT_SAVE_VERSION) {
            LOG.error("Unable to handle savestate version: {}", (Object)CURRENT_SAVE_VERSION);
            return false;
        }
        byte[] sys = new byte[16];
        this.buffer.get(sys);
        String sysName = new String(sys).trim();
        try {
            SystemLoader.SystemType type = SystemLoader.SystemType.valueOf(sysName);
            if (systemType != type) {
                LOG.error("Unable to handle savestate {}, actual systemType {}, expected: {}", new Object[]{this.fileName, type, systemType});
                return false;
            }
        }
        catch (Exception e) {
            LOG.error("Unable to handle savestate {}, unknown systemType {}, expected: {}", new Object[]{this.fileName, sysName, systemType});
            return false;
        }
        return true;
    }

    @Override
    public BaseStateHandler.Type getType() {
        return this.type;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public ByteBuffer getDataBuffer() {
        return this.buffer;
    }

    @Override
    public void processState() {
        StateUtil.processState(this, this.deviceList);
    }

    private void setDevicesWithContext(Set<Device> devs) {
        if (!this.deviceList.isEmpty()) {
            LOG.warn("Overwriting device list: {}", (Object)Arrays.toString(this.deviceList.toArray()));
        }
        this.deviceList = StateUtil.getDeviceOrderList(deviceClassSet, devs);
    }

    static enum Z80SavestateVersion {
        UNKNOWN(0),
        VER_1(1);

        private final int version;

        private Z80SavestateVersion(int version) {
            this.version = version;
        }

        public static Z80SavestateVersion parseVersion(int v) {
            for (Z80SavestateVersion ver : Z80SavestateVersion.values()) {
                if (v != ver.version) continue;
                return ver;
            }
            return UNKNOWN;
        }

        public int getVersion() {
            return this.version;
        }
    }
}

