/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.sound.fm;

import com.google.common.collect.Maps;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sound.sampled.AudioFormat;
import omegadrive.sound.SoundProvider;
import omegadrive.system.perf.Telemetry;
import omegadrive.util.LogHelper;
import omegadrive.util.SoundUtil;
import org.slf4j.Logger;

public class AudioRateControl {
    public static final double FM_CALCS_PER_MICROS = 1000000.0 / (double)SoundProvider.SAMPLE_RATE_HZ;
    private static final Logger LOG = LogHelper.getLogger(AudioRateControl.class.getSimpleName());
    private static final boolean DEBUG = false;
    private static final double HALF_LIMIT = 0.0125;
    private static final double LOWER_LIMIT = FM_CALCS_PER_MICROS * 0.9875;
    private static final double UPPER_LIMIT = FM_CALCS_PER_MICROS * 1.0125;
    static final double fastPace = 0.05;
    static final double slowPace = 0.025;
    private static final double targetBufferFactor = 0.75;
    private final StatsHolder statsHolder;
    private final int stereoBufferSize;
    private final int stereoTargetBufferSize;

    public AudioRateControl(String sourceName, AudioFormat audioFormat) {
        this.stereoBufferSize = SoundUtil.getStereoSamplesBufferSize(audioFormat);
        this.stereoTargetBufferSize = (int)((double)this.stereoBufferSize * 0.75);
        this.statsHolder = new StatsHolder(sourceName, SoundUtil.getSamplesBufferSize(audioFormat, 1000) >> 1);
        LOG.info("Init bufferLenMs: {}, targetBufferLenMs: {}, stereoTargetBufferSize: {}, stereoBufferSize: {}\naudioFormat: {}", new Object[]{SoundProvider.AUDIO_BUFFER_LEN_MS, (int)((double)SoundProvider.AUDIO_BUFFER_LEN_MS * 0.75), this.stereoTargetBufferSize, this.stereoBufferSize, audioFormat});
    }

    public static Optional<String> getLatestStats() {
        if (StatsHolder.statsHolderMap.isEmpty()) {
            return Optional.empty();
        }
        String s = StatsHolder.statsHolderMap.values().stream().map(StatsHolder::computeStringStats).collect(Collectors.joining(","));
        return Optional.ofNullable(s);
    }

    public double adaptiveRateControl(long stereoQueueLen, double fmCalcsPerMicros, int sampleRate) {
        boolean steadyState;
        double fm = fmCalcsPerMicros;
        boolean tooSmall = stereoQueueLen < (long)this.stereoTargetBufferSize;
        boolean tooBig = stereoQueueLen > (long)(this.stereoTargetBufferSize << 1);
        boolean bl = steadyState = !tooBig && !tooSmall;
        if (steadyState) {
            fm += fm > FM_CALCS_PER_MICROS ? -0.025 : 0.025;
        } else {
            fm += tooBig ? 0.025 : 0.0;
            fm += tooSmall ? -0.05 : 0.0;
        }
        double d = fm = fm > UPPER_LIMIT ? UPPER_LIMIT : Math.max(fm, LOWER_LIMIT);
        if (stereoQueueLen > this.statsHolder.maxLen) {
            this.statsHolder.maxLen = stereoQueueLen;
        }
        this.statsHolder.latestLen = stereoQueueLen;
        this.statsHolder.fmCalcPerMicros = fm;
        this.statsHolder.computeTelemetryStats();
        return fm;
    }

    private static class StatsHolder {
        public static final Map<String, StatsHolder> statsHolderMap = Maps.newHashMap();
        private static final NumberFormat bufferMsFormatter = new DecimalFormat("000");
        public long maxLen = 0L;
        public long latestLen = 0L;
        public long audioDelayMs = 0L;
        public double fmCalcPerMicros = 0.0;
        public final String sourceName;
        public String infoString;
        private final int samplesPerSecond;

        protected StatsHolder(String sourceName, int samplesPerSecond) {
            this.sourceName = sourceName;
            this.samplesPerSecond = samplesPerSecond;
            statsHolderMap.clear();
            statsHolderMap.put(sourceName, this);
        }

        protected void computeTelemetryStats() {
            this.audioDelayMs = (long)(1000.0 * (double)this.latestLen / (double)this.samplesPerSecond);
            Telemetry.getInstance().addSample(this.sourceName + ".fmCalcPerMicros", this.fmCalcPerMicros);
            Telemetry.getInstance().addSample(this.sourceName + ".audioDelayMs", this.audioDelayMs);
            Telemetry.getInstance().addSample(this.sourceName + ".audioQueueLen", this.latestLen);
        }

        protected String computeStringStats() {
            if (this.latestLen > 0L && this.maxLen > 0L) {
                long maxAudioDelayMs = (long)(1000.0 * (double)this.maxLen / (double)this.samplesPerSecond);
                this.infoString = this.sourceName + " " + bufferMsFormatter.format(this.audioDelayMs) + " / " + bufferMsFormatter.format(maxAudioDelayMs) + "ms";
            }
            return this.infoString;
        }
    }
}

