/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.sound.fm;

import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sound.sampled.AudioFormat;
import omegadrive.sound.fm.FmProvider;
import omegadrive.system.BaseSystem;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import org.jctools.queues.atomic.SpscAtomicArrayQueue;
import org.slf4j.Logger;

public class GenericAudioProvider
implements FmProvider {
    private static final Logger LOG = LogHelper.getLogger(GenericAudioProvider.class.getSimpleName());
    protected final AtomicInteger stereoQueueLen = new AtomicInteger();
    protected final Queue<Integer> sampleQueue;
    protected volatile boolean running = false;
    private final Integer[] stereoSamples = new Integer[2];
    private final int audioScaleBits;
    private final int sampleShift;

    public GenericAudioProvider(AudioFormat inputAudioFormat) {
        this(inputAudioFormat, 0, (int)inputAudioFormat.getSampleRate() << 2);
    }

    public GenericAudioProvider(AudioFormat inputAudioFormat, int audioScaleBits, int maxQueueLen) {
        this.sampleQueue = new SpscAtomicArrayQueue(maxQueueLen);
        this.sampleShift = 16 - inputAudioFormat.getSampleSizeInBits();
        this.audioScaleBits = audioScaleBits;
        LOG.info("Input sound source format: {}, audioScaleBits: {}", (Object)inputAudioFormat, (Object)audioScaleBits);
    }

    @Override
    public int updateStereo16(int[] buf_lr, int offset, int count) {
        int i;
        if (!this.running) {
            return 0;
        }
        int end = (count << 1) + (offset <<= 1);
        int queueIndicativeLen = this.stereoQueueLen.get();
        for (i = offset; i < end && queueIndicativeLen > 0; i += 2) {
            if (!this.fillStereoSamples(this.stereoSamples)) {
                LOG.warn("Null left sample QL{} P{}", (Object)queueIndicativeLen, (Object)i);
                break;
            }
            queueIndicativeLen = this.stereoQueueLen.addAndGet(-2);
            buf_lr[i] = (short)(this.stereoSamples[0] & 0xFFFF) << this.audioScaleBits;
            buf_lr[i + 1] = (short)(this.stereoSamples[1] & 0xFFFF) << this.audioScaleBits;
        }
        return i;
    }

    private boolean fillStereoSamples(Integer[] stereoSamples) {
        stereoSamples[0] = this.sampleQueue.peek();
        if (stereoSamples[0] == null) {
            return false;
        }
        this.sampleQueue.poll();
        stereoSamples[1] = this.sampleQueue.poll();
        if (stereoSamples[1] == null) {
            stereoSamples[1] = stereoSamples[0];
            LOG.warn("Null right sample, left: {}", (Object)stereoSamples[0]);
        }
        assert ((stereoSamples[0] & 1) == 1 && (stereoSamples[1] & 1) == 0);
        return true;
    }

    protected void addStereoSample(int left, int right) {
        if (!this.running) {
            return;
        }
        boolean res = this.sampleQueue.offer(Util.getFromIntegerCache(left << this.sampleShift | 1));
        boolean res2 = this.sampleQueue.offer(Util.getFromIntegerCache(right << this.sampleShift & 0xFFFFFFFE));
        this.stereoQueueLen.addAndGet(2);
        if (!res) {
            if (!BaseSystem.fullThrottle) {
                LOG.warn("Left sample dropped: {}", (Object)Util.th(left));
            }
            this.stereoQueueLen.decrementAndGet();
        }
        if (!res2) {
            if (!BaseSystem.fullThrottle) {
                LOG.warn("Right sample dropped: {}", (Object)Util.th(right));
            }
            this.stereoQueueLen.decrementAndGet();
        }
    }

    protected void addMonoSample(int sample) {
        if (!this.running) {
            return;
        }
        this.addStereoSample(sample, sample);
    }

    public void start() {
        this.running = true;
    }

    public void stop() {
        this.running = false;
    }

    @Override
    public void init() {
        this.reset();
    }

    @Override
    public int readRegister(int type, int regNumber) {
        return 0;
    }

    @Override
    public void tick() {
    }

    @Override
    public void reset() {
        this.stop();
        this.sampleQueue.clear();
        this.stereoQueueLen.set(0);
        this.start();
    }
}

