/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.sound.fm;

import javax.sound.sampled.AudioFormat;
import omegadrive.sound.SoundProvider;
import omegadrive.sound.fm.FmProvider;
import omegadrive.sound.fm.ym2612.YM2612;
import omegadrive.sound.fm.ym2612.nukeykt.Ym2612Nuke;
import omegadrive.sound.javasound.AbstractSoundManager;
import omegadrive.util.RegionDetector;

public interface MdFmProvider
extends FmProvider {
    public static final int FM_ADDRESS_PORT0 = 0;
    public static final int FM_ADDRESS_PORT1 = 2;
    public static final int FM_DATA_PORT0 = 1;
    public static final int FM_DATA_PORT1 = 3;
    public static final int FM_STATUS_TIMER_A_BIT_MASK = 1;
    public static final int FM_STATUS_TIMER_B_BIT_MASK = 2;
    public static final int FM_STATUS_BUSY_BIT_MASK = 128;
    public static final int FM_MODE_LOAD_A_MASK = 1;
    public static final int FM_MODE_LOAD_B_MASK = 2;
    public static final int FM_MODE_ENABLE_A_MASK = 4;
    public static final int FM_MODE_ENABLE_B_MASK = 8;
    public static final int FM_MODE_RESET_A_MASK = 16;
    public static final int FM_MODE_RESET_B_MASK = 32;

    public static MdFmProvider createFastInstance(RegionDetector.Region region, AudioFormat audioFormat) {
        SoundProvider.LOG.warn("YM2612, creating fast instance, less accurate");
        return MdFmProvider.createInstance(region, audioFormat, true);
    }

    public static MdFmProvider createInstance(RegionDetector.Region region, AudioFormat audioFormat) {
        return MdFmProvider.createInstance(region, audioFormat, false);
    }

    private static MdFmProvider createInstance(RegionDetector.Region region, AudioFormat audioFormat, boolean fast) {
        double clock = SoundProvider.getFmSoundClock(region);
        MdFmProvider fmProvider = fast ? new YM2612((int)clock, (int)audioFormat.getSampleRate()) : new Ym2612Nuke(AbstractSoundManager.audioFormat, clock);
        SoundProvider.LOG.info("FM instance {}, clock: {}, sampleRate: {}", new Object[]{fmProvider.getClass().getSimpleName(), clock, Float.valueOf(audioFormat.getSampleRate())});
        return fmProvider;
    }
}

