/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.sound.fm.ym2612;

public class Ym2612RegSupport {
    protected final int[][] ym2612Reg = new int[2][256];
    protected int addressLatch;

    public int readRegister(int type, int regNumber) {
        return this.ym2612Reg[type][regNumber];
    }

    public void write(int addr, int data) {
        switch (addr &= 3) {
            case 0: {
                this.addressLatch = data;
                break;
            }
            case 2: {
                this.addressLatch = data + 256;
                break;
            }
            default: {
                this.writeDataPort(data);
            }
        }
    }

    protected void writeDataPort(int data) {
        int realAddrReg;
        int realAddr = this.addressLatch;
        int regPart = realAddr >= 256 ? 1 : 0;
        int n = realAddrReg = regPart > 0 ? realAddr - 256 : realAddr;
        if (realAddr < 48) {
            this.ym2612Reg[regPart][realAddrReg] = data;
        }
    }
}

