/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.sound.javasound;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.SourceDataLine;
import mcd.pcm.BlipPcmProvider;
import omegadrive.Device;
import omegadrive.SystemLoader;
import omegadrive.sound.PcmProvider;
import omegadrive.sound.PwmProvider;
import omegadrive.sound.SoundDevice;
import omegadrive.sound.SoundProvider;
import omegadrive.sound.fm.FmProvider;
import omegadrive.sound.javasound.JalSoundManager;
import omegadrive.sound.javasound.JavaSoundManager;
import omegadrive.sound.persist.FileSoundPersister;
import omegadrive.sound.persist.SoundPersister;
import omegadrive.sound.psg.PsgProvider;
import omegadrive.system.SysUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.PriorityThreadFactory;
import omegadrive.util.RegionDetector;
import omegadrive.util.SoundUtil;
import org.slf4j.Logger;
import s32x.pwm.BlipPwmProvider;

public abstract class AbstractSoundManager
implements SoundProvider {
    private static final Logger LOG = LogHelper.getLogger(AbstractSoundManager.class.getSimpleName());
    protected static final SoundPersister.SoundType DEFAULT_SOUND_TYPE = SoundPersister.SoundType.BOTH;
    private static final int OUTPUT_SAMPLE_SIZE = 16;
    private static final int OUTPUT_CHANNELS = 2;
    public static final AudioFormat audioFormat = new AudioFormat(SoundProvider.SAMPLE_RATE_HZ, 16, 2, true, false);
    private static final Map<SoundDevice.SoundDeviceType, SoundDevice> noSoundMap = ImmutableMap.of((Object)((Object)SoundDevice.SoundDeviceType.FM), (Object)FmProvider.NO_SOUND, (Object)((Object)SoundDevice.SoundDeviceType.PSG), (Object)PsgProvider.NO_SOUND, (Object)((Object)SoundDevice.SoundDeviceType.PWM), (Object)PwmProvider.NO_SOUND, (Object)((Object)SoundDevice.SoundDeviceType.PCM), (Object)PcmProvider.NO_SOUND);
    public volatile boolean close;
    protected ExecutorService executorService;
    protected volatile Map<SoundDevice.SoundDeviceType, SoundDevice> soundDeviceMap;
    protected volatile Map<SoundDevice.SoundDeviceType, SoundDevice> activeSoundDeviceMap;
    protected SoundPersister soundPersister;
    protected int fmSize;
    protected int psgSize;
    protected SourceDataLine dataLine;
    protected boolean soundEnabled = true;
    private SystemLoader.SystemType type;
    protected RegionDetector.Region region;
    protected volatile int soundDeviceSetup = SoundDevice.SoundDeviceType.NONE.getBit();
    protected List<SoundDevice.MutableDevice> mutableDeviceList = new ArrayList<SoundDevice.MutableDevice>();
    protected AtomicBoolean initedOnce = new AtomicBoolean(false);

    public static SoundProvider createSoundProvider(SystemLoader.SystemType systemType) {
        if (!ENABLE_SOUND) {
            LOG.warn("Sound disabled");
            return NO_SOUND;
        }
        AbstractSoundManager jsm = JAL_SOUND_MGR ? new JalSoundManager() : new JavaSoundManager();
        jsm.type = systemType;
        return jsm;
    }

    @Override
    public void init(RegionDetector.Region region) {
        this.region = region;
        this.activeSoundDeviceMap = SysUtil.getSoundDevices(this.type, region);
        this.soundDeviceMap = ImmutableMap.copyOf(this.activeSoundDeviceMap);
        this.updateSoundDeviceSetup();
        this.soundPersister = new FileSoundPersister();
        this.fmSize = SoundProvider.getFmBufferIntSize(audioFormat);
        this.psgSize = SoundProvider.getPsgBufferByteSize(audioFormat);
        this.init();
    }

    protected void updateSoundDeviceSetup() {
        this.soundDeviceSetup = 0;
        for (Map.Entry<SoundDevice.SoundDeviceType, SoundDevice> entry : this.activeSoundDeviceMap.entrySet()) {
            SoundDevice.SoundDeviceType type = entry.getKey();
            SoundDevice current = this.soundDeviceMap.get((Object)type);
            SoundDevice noSound = noSoundMap.get((Object)type);
            assert (current != null && noSound != null);
            this.soundDeviceSetup |= current != noSound ? type.getBit() : 0;
        }
    }

    @Override
    public void init() {
        assert (this.initedOnce.compareAndSet(false, true));
        assert (this.dataLine == null && this.executorService == null);
        this.dataLine = SoundUtil.createDataLine(audioFormat);
        this.executorService = Executors.newSingleThreadExecutor(new PriorityThreadFactory(10, AbstractSoundManager.class.getSimpleName()));
        LOG.info("Output audioFormat: {}, bufferSize: {}, region: {}", new Object[]{audioFormat, this.fmSize, this.region});
    }

    @Override
    public PsgProvider getPsg() {
        return (PsgProvider)this.activeSoundDeviceMap.get((Object)SoundDevice.SoundDeviceType.PSG);
    }

    @Override
    public FmProvider getFm() {
        return (FmProvider)this.activeSoundDeviceMap.get((Object)SoundDevice.SoundDeviceType.FM);
    }

    @Override
    public PwmProvider getPwm() {
        return (PwmProvider)this.activeSoundDeviceMap.get((Object)SoundDevice.SoundDeviceType.PWM);
    }

    @Override
    public PcmProvider getPcm() {
        return (PcmProvider)this.activeSoundDeviceMap.get((Object)SoundDevice.SoundDeviceType.PCM);
    }

    @Override
    public void reset() {
        LOG.info("Resetting sound");
        this.close = true;
        if (this.initedOnce.get()) {
            List<Runnable> list = this.executorService.shutdownNow();
            LOG.info("Closing sound, stopping background tasks: #{}", (Object)list.size());
            SoundUtil.close(this.dataLine);
            this.setRecording(false);
        }
    }

    @Override
    public void close() {
        this.reset();
    }

    @Override
    public boolean isRecording() {
        return this.soundPersister.isRecording();
    }

    @Override
    public void setRecording(boolean recording) {
        if (this.isRecording() && !recording) {
            this.soundPersister.stopRecording();
        } else if (!this.isRecording() && recording) {
            this.soundPersister.startRecording(DEFAULT_SOUND_TYPE);
        }
    }

    @Override
    public void addExternalSoundSource(SoundDevice.MutableDevice mutableDevice) {
        this.mutableDeviceList.add(mutableDevice);
    }

    @Override
    public boolean isMute() {
        return !this.soundEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.soundEnabled = enabled;
        LOG.info("Set sound enabled: {}", (Object)enabled);
        BlipPcmProvider.mute = !enabled;
        BlipPwmProvider.mute = !enabled;
    }

    @Override
    public void setEnabled(Device device, boolean enabled) {
        if (device instanceof SoundDevice) {
            boolean isEnabledNow;
            SoundDevice sd = (SoundDevice)device;
            SoundDevice noSound = noSoundMap.get((Object)sd.getType());
            assert (noSound != null);
            boolean bl = isEnabledNow = device != noSound;
            if (enabled != isEnabledNow) {
                SoundDevice playDevice = this.soundDeviceMap.get((Object)sd.getType());
                SoundDevice currentDevice = enabled ? playDevice : noSound;
                this.activeSoundDeviceMap.put(sd.getType(), currentDevice);
                this.updateSoundDeviceSetup();
                LOG.info("{} enabled: {}", (Object)sd.getType(), (Object)enabled);
            }
        }
    }
}

