/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.sound.javasound;

import java.nio.FloatBuffer;
import java.util.List;
import java.util.ServiceLoader;
import omegadrive.sound.SoundDevice;
import omegadrive.sound.javasound.AbstractSoundManager;
import omegadrive.system.perf.Telemetry;
import omegadrive.util.LogHelper;
import omegadrive.util.SoundUtil;
import omegadrive.util.Util;
import org.jaudiolibs.audioservers.AudioClient;
import org.jaudiolibs.audioservers.AudioConfiguration;
import org.jaudiolibs.audioservers.AudioServer;
import org.jaudiolibs.audioservers.AudioServerProvider;
import org.jaudiolibs.audioservers.ext.ClientID;
import org.jaudiolibs.audioservers.ext.Connections;
import org.jaudiolibs.audioservers.javasound.JSTimingMode;
import org.slf4j.Logger;

public class JalSoundManager
extends AbstractSoundManager
implements AudioClient {
    private static final Logger LOG = LogHelper.getLogger(JalSoundManager.class.getSimpleName());
    private static final int bufferSize = SoundUtil.getAudioLineBufferSize(audioFormat) >> 2;
    private static final String lib = "JavaSound";
    private static final int JAL_TIMING_MODE = Integer.parseInt(System.getProperty("helios.jal.timing.mode", "2"));
    private JSTimingMode timingMode = JSTimingMode.Estimated;
    volatile int[] fm_buf_ints;
    volatile byte[] mix_buf_bytes16Stereo;
    volatile byte[] psg_buf_bytes;
    volatile int fmSizeMono;
    private float[] buffer;
    private Telemetry telemetry;
    private volatile int samplesProducedCount;
    private volatile int samplesConsumedCount;
    private volatile int audioThreadLoops;
    private volatile int audioThreadEmptyLoops;

    @Override
    public void init() {
        this.fm_buf_ints = new int[this.fmSize];
        this.mix_buf_bytes16Stereo = new byte[this.fm_buf_ints.length << 1];
        this.psg_buf_bytes = new byte[this.psgSize];
        this.fmSizeMono = (int)Math.round((double)this.fmSize / 2.0);
        this.telemetry = Telemetry.getInstance();
        this.startAudio();
    }

    private void startAudio() {
        AudioServerProvider provider = null;
        for (AudioServerProvider p : ServiceLoader.load(AudioServerProvider.class)) {
            if (!lib.equals(p.getLibraryName())) continue;
            provider = p;
            break;
        }
        if (provider == null) {
            throw new NullPointerException("No AudioServer found that matches : JavaSound");
        }
        this.detectTimingMode();
        JalSoundManager client = this;
        AudioConfiguration config = new AudioConfiguration(audioFormat.getSampleRate(), 0, audioFormat.getChannels(), bufferSize, false, new Object[]{new ClientID("JalSoundManager"), this.timingMode, Connections.OUTPUT});
        try {
            AudioServer server = provider.createServer(config, (AudioClient)client);
            this.executorService.submit(this.getServerRunnable(server));
            LOG.info("Audio Max buffer size (in samples per channel): {}", (Object)bufferSize);
        }
        catch (Throwable t) {
            LOG.error("Error", t);
            t.printStackTrace();
        }
    }

    private void detectTimingMode() {
        for (JSTimingMode mode : JSTimingMode.values()) {
            if (mode.ordinal() != JAL_TIMING_MODE) continue;
            this.timingMode = mode;
            break;
        }
        LOG.info("Using timing mode: {}", (Object)this.timingMode);
    }

    private Runnable getServerRunnable(AudioServer server) {
        return Util.wrapRunnableEx(() -> {
            try {
                server.run();
            }
            catch (InterruptedException ie) {
                LOG.info("interrupted");
                return;
            }
            catch (Error | Exception ex) {
                LOG.error("Error", ex);
                ex.printStackTrace();
            }
        });
    }

    private int playOnceStereo(int fmBufferLenMono) {
        int fmMonoActual = this.getFm().updateStereo16(this.fm_buf_ints, 0, fmBufferLenMono) >> 1;
        fmBufferLenMono = (this.soundDeviceSetup & SoundDevice.SoundDeviceType.FM.getBit()) > 0 ? fmMonoActual : fmBufferLenMono;
        this.getPsg().updateMono8(this.psg_buf_bytes, 0, fmBufferLenMono);
        int fmBufferLenStereo = fmBufferLenMono << 1;
        this.samplesProducedCount += fmBufferLenStereo;
        try {
            SoundUtil.intStereo14ToByteStereo16MixFloat(this.fm_buf_ints, this.buffer, this.psg_buf_bytes, fmBufferLenStereo);
        }
        catch (Exception e) {
            LOG.error("Unexpected sound error", (Throwable)e);
        }
        return fmMonoActual;
    }

    @Override
    public void onNewFrame() {
        this.doStats();
        this.getFm().onNewFrame();
    }

    private void doStats() {
        this.samplesProducedCount = 0;
        this.samplesConsumedCount = 0;
        this.audioThreadEmptyLoops = 0;
        this.audioThreadLoops = 0;
    }

    public void configure(AudioConfiguration context) {
        LOG.info("configure");
    }

    public boolean process(long time, List<FloatBuffer> inputs, List<FloatBuffer> outputs, int nframes) {
        int resFrames;
        FloatBuffer left = outputs.get(0);
        FloatBuffer right = outputs.get(1);
        if (this.buffer == null || this.buffer.length != nframes << 1) {
            this.buffer = new float[nframes << 1];
        }
        if ((resFrames = this.playOnceStereo(nframes)) != nframes) {
            // empty if block
        }
        int k = 0;
        int i = 0;
        while (i < nframes) {
            left.put(this.buffer[k]);
            right.put(this.buffer[k + 1]);
            if (k == this.buffer.length) {
                k = 0;
                LOG.warn("wrap");
            }
            ++i;
            k += 2;
        }
        return !this.close;
    }

    public void shutdown() {
        LOG.info("Shutdown");
    }
}

