/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.sound.msumd;

import java.io.File;
import java.util.Optional;
import javax.sound.sampled.AudioFormat;
import omegadrive.bus.md.MdBus;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import org.slf4j.Logger;

public interface MsuMdHandler {
    public static final Logger LOG = LogHelper.getLogger(MdBus.class.getSimpleName());
    public static final int CLOCK_ADDR = 10559519;
    public static final int CMD_ADDR = 10559504;
    public static final int CMD_ARG_ADDR = 10559506;
    public static final int MCD_STATUS_ADDR = 10559520;
    public static final int MCD_WRAM_START = 0x420000;
    public static final int MCD_WRAM_END = 4327423;
    public static final int MCD_GATE_ARRAY_START = 10559489;
    public static final int MCD_MEMWP = 10559490;
    public static final int MCD_MMOD = 10559491;
    public static final int MCD_COMF = 10559503;
    public static final int CDDA_SAMPLE_RATE = 44100;
    public static final AudioFormat CDDA_FORMAT = new AudioFormat(44100.0f, 16, 2, true, false);
    public static final MsuMdHandler NO_OP_HANDLER = new MsuMdHandler(){

        @Override
        public int handleMsuMdRead(int address, Size size) {
            return 0;
        }

        @Override
        public void handleMsuMdWrite(int address, int data, Size size) {
        }
    };
    public static final TrackDataHolder NO_TRACK = new TrackDataHolder();

    public int handleMsuMdRead(int var1, Size var2);

    public void handleMsuMdWrite(int var1, int var2, Size var3);

    default public void close() {
    }

    public static class TrackDataHolder {
        CueFileDataType type = CueFileDataType.UNKNOWN;
        Optional<Boolean> cueLoop = Optional.empty();
        Optional<Integer> cueLoopPoint = Optional.empty();
        Optional<File> waveFile = Optional.empty();
        Optional<Integer> numBytes = Optional.empty();
        Optional<Integer> startFrame = Optional.empty();
    }

    public static class MsuCommandArg {
        MsuCommand command = MsuCommand.UNKNOWN;
        int arg;
        int arg1;
    }

    public static enum CueFileDataType {
        BINARY,
        WAVE,
        OGG,
        UNKNOWN;


        static CueFileDataType getFileType(String type) {
            for (CueFileDataType c : CueFileDataType.values()) {
                if (!c.name().equalsIgnoreCase(type)) continue;
                return c;
            }
            return UNKNOWN;
        }
    }

    public static enum MsuCommand {
        PLAY(17),
        PLAY_LOOP(18),
        PAUSE(19),
        RESUME(20),
        VOL(21),
        NO_SEEK(22),
        PLAY_OFFSET(26),
        UNKNOWN(-1);

        private final int val;

        private MsuCommand(int val) {
            this.val = val;
        }

        public static MsuCommand getMsuCommand(int val) {
            for (MsuCommand c : MsuCommand.values()) {
                if (c.val != val) continue;
                return c;
            }
            LOG.error("Unknown command code: {}", (Object)val);
            return UNKNOWN;
        }
    }
}

