/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.system.gb;

import eu.rekawek.coffeegb.gpu.Display;
import java.awt.event.KeyListener;
import java.util.Arrays;
import omegadrive.system.SystemProvider;
import omegadrive.ui.DisplayWindow;
import omegadrive.ui.SwingWindow;
import omegadrive.vdp.model.BaseVdpAdapter;

public class HeliosDisplay
implements Display,
BaseVdpAdapter.ScreenDataSupplier {
    public static final int DISPLAY_WIDTH = 160;
    public static final int DISPLAY_HEIGHT = 144;
    public static final int[] COLORS = new int[]{15136986, 10078342, 4421993, 335658};
    static final int SCALE = 3;
    private final int[] rgb;
    private int i;
    private boolean enabled;
    private final DisplayWindow window;
    private SystemProvider.NewFrameListener system;

    public HeliosDisplay() {
        this.window = new SwingWindow(null);
        this.window.init();
        this.rgb = new int[23040];
    }

    public HeliosDisplay(SystemProvider.NewFrameListener system, DisplayWindow window) {
        this.window = window;
        this.system = system;
        this.rgb = new int[23040];
    }

    public static int translateGbcRgb(int gbcRgb) {
        int r = gbcRgb >> 0 & 0x1F;
        int g = gbcRgb >> 5 & 0x1F;
        int b = gbcRgb >> 10 & 0x1F;
        int result = r * 8 << 16;
        result |= g * 8 << 8;
        return result |= b * 8 << 0;
    }

    public void putDmgPixel(int color) {
        this.rgb[this.i++] = COLORS[color];
        this.i %= this.rgb.length;
    }

    public void putColorPixel(int gbcRgb) {
        this.rgb[this.i++] = HeliosDisplay.translateGbcRgb(gbcRgb);
    }

    public void requestRefresh() {
        if (!this.enabled) {
            Arrays.fill(this.rgb, 0);
        }
        this.i = 0;
        this.system.newFrame();
    }

    public void waitForRefresh() {
    }

    public void enableLcd() {
        this.enabled = true;
    }

    public void disableLcd() {
        this.enabled = false;
    }

    public void addKeyListener(KeyListener listener) {
        this.window.addKeyListener(listener);
    }

    @Override
    public int[] getScreen() {
        return this.rgb;
    }

    static {
        System.setProperty("helios.ui.scale", String.valueOf(3));
    }
}

