/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.system.nes;

import com.grapeshot.halfnes.NES;
import com.grapeshot.halfnes.audio.AudioOutInterface;
import com.grapeshot.halfnes.ui.ControllerImpl;
import com.grapeshot.halfnes.ui.ControllerInterface;
import com.grapeshot.halfnes.ui.GUIInterface;
import com.grapeshot.halfnes.video.RGBRenderer;
import java.nio.file.Path;
import omegadrive.input.InputProvider;
import omegadrive.input.KeyboardInputHelper;
import omegadrive.system.SystemProvider;
import omegadrive.system.nes.Nes;
import omegadrive.util.VideoMode;
import omegadrive.vdp.model.BaseVdpAdapter;
import omegadrive.vdp.model.BaseVdpProvider;

public class NesHelper {
    public static final ControllerImpl cnt1 = new ControllerImpl(0, KeyboardInputHelper.keyboardStringBindings.row((Object)InputProvider.PlayerNumber.P1));
    public static final ControllerImpl cnt2 = new ControllerImpl(1, KeyboardInputHelper.keyboardStringBindings.row((Object)InputProvider.PlayerNumber.P2));

    public static NesGUIInterface createNes(Path romFile, Nes nesSys, AudioOutInterface audio) {
        NES nes = new NES(audio);
        NesGUIInterface gui = NesHelper.createGuiWrapper(nes, nesSys);
        nes.setControllers((ControllerInterface)cnt1, (ControllerInterface)cnt2);
        nes.setGui((GUIInterface)gui);
        nes.setRom(romFile.toAbsolutePath().toString());
        return gui;
    }

    public static NesGUIInterface createGuiWrapper(final NES instance1, final SystemProvider.NewFrameListener nesSystem) {
        return new NesGUIInterface(){
            private NES localInstance;
            private final RGBRenderer renderer;
            private int[] screen;
            private final BaseVdpProvider vdpProvider;
            {
                this.localInstance = instance1;
                this.renderer = new RGBRenderer();
                this.vdpProvider = BaseVdpAdapter.getVdpProviderWrapper(VideoMode.NTSCU_H32_V30, this);
            }

            @Override
            public BaseVdpProvider getVdpProvider() {
                return this.vdpProvider;
            }

            public NES getNes() {
                return this.localInstance;
            }

            public void setNES(NES nes) {
                this.localInstance = nes;
            }

            public void setFrame(int[] frame, int[] bgcolor, boolean dotcrawl) {
                this.renderer.renderData(frame, bgcolor, dotcrawl);
                this.screen = frame;
                nesSystem.newFrame();
            }

            @Override
            public int[] getScreen() {
                return this.screen;
            }

            public void messageBox(String message) {
            }

            public void run() {
                this.localInstance.run();
            }

            public void render() {
                System.out.println("render");
            }

            public void loadROMs(String path) {
                this.localInstance.loadROM(path);
            }

            public void close() {
                this.localInstance.quit();
            }
        };
    }

    public static interface NesGUIInterface
    extends GUIInterface,
    BaseVdpAdapter.ScreenDataSupplier {
        @Override
        public int[] getScreen();

        public BaseVdpProvider getVdpProvider();
    }
}

