/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.system.nes;

import com.grapeshot.halfnes.audio.AudioOutInterface;
import javax.sound.sampled.AudioFormat;
import omegadrive.sound.SoundProvider;
import omegadrive.sound.fm.GenericAudioProvider;
import omegadrive.util.LogHelper;
import omegadrive.util.RegionDetector;
import org.slf4j.Logger;

public class NesSoundWrapper
extends GenericAudioProvider
implements AudioOutInterface {
    private static final Logger LOG = LogHelper.getLogger(NesSoundWrapper.class.getSimpleName());
    private static final double VOLUME = 0.79998779296875;
    public static final AudioFormat nesAudioFormat = new AudioFormat(SoundProvider.SAMPLE_RATE_HZ, 16, 1, true, false);

    public NesSoundWrapper(RegionDetector.Region region) {
        super(nesAudioFormat);
        this.start();
    }

    public void outputSample(int sample) {
        sample = (sample = (int)((double)sample * 0.79998779296875)) < Short.MIN_VALUE ? Short.MIN_VALUE : (sample > Short.MAX_VALUE ? Short.MAX_VALUE : sample);
        this.addMonoSample(sample);
    }

    public void flushFrame(boolean waitIfBufferFull) {
    }

    public boolean bufferHasLessThan(int monoSamples) {
        return this.stereoQueueLen.get() < monoSamples << 1;
    }

    public void pause() {
        this.stop();
    }

    public void resume() {
        this.start();
    }

    public void destroy() {
        this.reset();
    }
}

