/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.system.perf;

import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import omegadrive.sound.fm.AudioRateControl;
import omegadrive.system.SystemProvider;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class Telemetry {
    private static final Logger LOG = LogHelper.getLogger(Telemetry.class.getSimpleName());
    public static final boolean enable = false;
    private static final Function<Map<?, Double>, String> toStringFn = map -> {
        String res = Arrays.toString(map.values().toArray());
        return res.substring(1, res.length() - 2);
    };
    private static final BiFunction<Timing, Timing, String> toTimestampFn = (now, prev) -> (double)(now.nanoTime - prev.nanoTime) / (double)Util.MILLI_IN_NS + "," + String.valueOf(Instant.ofEpochMilli(now.instantNow));
    private static Telemetry telemetry = new Telemetry();
    private static final NumberFormat fpsFormatter = new DecimalFormat("#0.00");
    private static final int STATS_EVERY_FRAMES = 50;
    private static final Timing NO_TIMING = new Timing();
    private Path telemetryFile;
    private SystemProvider.SystemClock systemClock;
    private long frameCounter = 0L;
    private final Table<String, Long, Double> data = TreeBasedTable.create();
    private final Map<Long, Timing> frameTimeStamp = new HashMap<Long, Timing>();

    private void addFrameTimestamp() {
        Timing t = new Timing();
        t.instantNow = Instant.now().toEpochMilli();
        t.nanoTime = System.nanoTime();
        this.frameTimeStamp.put(this.systemClock.getFrameCounter(), t);
    }

    public static Telemetry resetClock(SystemProvider.SystemClock clock) {
        telemetry = new Telemetry();
        Telemetry.telemetry.systemClock = clock;
        return telemetry;
    }

    public static Telemetry getInstance() {
        return telemetry;
    }

    private static void writeToFile(Path file, String res) {
        try {
            Files.write(file, res.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            LOG.error("Unable to write to: {}", (Object)file.toAbsolutePath());
        }
    }

    public void addSample(String type, double value) {
    }

    private String getAvgFpsRounded(double avgFrameTimeMs) {
        return fpsFormatter.format(1000.0 / avgFrameTimeMs);
    }

    public double getAvgFps(long fc) {
        return 1000.0 / this.getAvgFrameTimeMs(fc);
    }

    public double getAvgFrameTimeMs(long fc) {
        Timing current = this.frameTimeStamp.get(fc);
        Timing prev = this.frameTimeStamp.getOrDefault(fc - 50L, NO_TIMING);
        if (prev == NO_TIMING) {
            return 16.6;
        }
        return 1.0 * (double)(current.instantNow - prev.instantNow) / 50.0;
    }

    public boolean hasNewStats() {
        return this.frameCounter % 50L == 0L;
    }

    public Optional<String> getNewStats() {
        Optional<Object> o = Optional.empty();
        if (this.hasNewStats()) {
            Optional<String> arc = AudioRateControl.getLatestStats();
            double ft = this.getAvgFrameTimeMs(this.frameCounter);
            o = Optional.of(fpsFormatter.format(ft) + "ms (" + this.getAvgFpsRounded(ft) + "fps)" + arc.map(s -> ", " + s).orElse(""));
        }
        return o;
    }

    public void reset() {
        this.frameCounter = 0L;
        this.data.clear();
        this.frameTimeStamp.clear();
        this.telemetryFile = null;
    }

    public Optional<String> newFrame(double frameTimeNs, double driftNs) {
        this.addFrameTimestamp();
        this.addSample("fps", 1.0 * (double)Util.SECOND_IN_NS / frameTimeNs);
        this.addSample("driftNs", driftNs);
        Optional<String> os = this.getNewStats();
        this.newFrame();
        return os;
    }

    public void newFrame() {
        ++this.frameCounter;
    }

    private String toLogString(Long num) {
        return num + "," + toStringFn.apply(this.data.column((Object)num)) + "," + toTimestampFn.apply(this.frameTimeStamp.getOrDefault(num, NO_TIMING), this.frameTimeStamp.getOrDefault(num - 1L, NO_TIMING));
    }

    public long getFrameCounter() {
        return this.frameCounter;
    }

    public int getCycleCounter() {
        return this.systemClock.getCycleCounter();
    }

    private /* synthetic */ void lambda$newFrame$4(String res) {
        Telemetry.writeToFile(this.telemetryFile, res);
    }

    private /* synthetic */ void lambda$newFrame$3(String header) {
        Telemetry.writeToFile(this.telemetryFile, header);
    }

    static class Timing {
        long instantNow;
        long nanoTime;

        Timing() {
        }
    }
}

