/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.ui;

import java.awt.event.KeyListener;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Optional;
import omegadrive.system.MediaSpecHolder;
import omegadrive.system.SystemProvider;
import omegadrive.util.FileUtil;
import omegadrive.util.RegionDetector;
import omegadrive.util.VideoMode;

public interface DisplayWindow
extends RegionDetector.RegionOverrideSupplier {
    public static final String APP_NAME = "Helios";
    public static final String VERSION = FileUtil.loadVersionFromManifest();
    public static final String FRAME_TITLE_HEAD = "Helios " + VERSION;
    public static final int SHOW_INFO_FRAMES_DELAY = 120;
    public static final DisplayWindow HEADLESS_INSTANCE = new DisplayWindow(){

        @Override
        public void addKeyListener(KeyListener keyAdapter) {
        }

        @Override
        public void setRomData(MediaSpecHolder rom) {
        }

        @Override
        public void init() {
        }

        @Override
        public void renderScreenLinear(DisplayContext displayContext) {
        }

        @Override
        public void resetScreen() {
        }

        @Override
        public void setFullScreen(boolean value) {
        }

        @Override
        public String getRegionOverride() {
            return null;
        }

        @Override
        public void reloadSystem(SystemProvider systemProvider) {
        }
    };

    public void setRomData(MediaSpecHolder var1);

    public void init();

    public void renderScreenLinear(DisplayContext var1);

    public void resetScreen();

    public void setFullScreen(boolean var1);

    @Override
    public String getRegionOverride();

    public void reloadSystem(SystemProvider var1);

    public void addKeyListener(KeyListener var1);

    default public void close() {
    }

    default public void reloadControllers(Collection<String> list) {
    }

    default public void showInfo(String info) {
    }

    default public String getAboutString() {
        int year = LocalDate.now().getYear();
        Object yrString = year == 2018 ? "2018" : "2018-" + year;
        String res = FRAME_TITLE_HEAD + "\nA Java-based multi-system emulator.";
        res = res + "\n\nCopyright " + (String)yrString + ", Federico Berti";
        res = res + "\n\nSee CREDITS.TXT for more information";
        res = res + "\n\nReleased under GPL v.3.0 license.";
        return res;
    }

    public static class DisplayContext {
        public int[] data;
        public VideoMode videoMode;
        public Optional<String> label = Optional.empty();
        public Optional<Double> fps = Optional.empty();
        public Optional<Integer> megaCdLedState = Optional.empty();
    }
}

