/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.concurrent.atomic.AtomicBoolean;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public class MouseCursorHandler
extends MouseMotionAdapter {
    private static final Logger LOG = LogHelper.getLogger(MouseCursorHandler.class.getSimpleName());
    private final int hideMouseDelayFrames = Integer.parseInt(System.getProperty("ui.hide.mouse.delay.frames", "180"));
    private final BufferedImage cursorImg = new BufferedImage(16, 16, 2);
    private final Cursor blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(this.cursorImg, new Point(0, 0), "blank cursor");
    private final Cursor defaultCursor = Cursor.getDefaultCursor();
    private final AtomicBoolean hasMoved = new AtomicBoolean();
    private long frameCnt;
    private long lastMovementFrame;
    private final Component cmp;

    public MouseCursorHandler(Component cmp) {
        cmp.addMouseMotionListener(this);
        this.cmp = cmp;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.hasMoved.set(true);
    }

    public void newFrame() {
        boolean frameInterval;
        ++this.frameCnt;
        boolean isShowingCursor = this.defaultCursor.equals(this.cmp.getCursor());
        boolean hasMovedB = this.hasMoved.compareAndSet(true, false);
        boolean bl = frameInterval = this.frameCnt - this.lastMovementFrame > (long)this.hideMouseDelayFrames;
        if (!isShowingCursor && hasMovedB) {
            this.cmp.setCursor(null);
        } else if (isShowingCursor && !hasMovedB && frameInterval) {
            this.cmp.setCursor(this.blankCursor);
        }
        if (hasMovedB) {
            this.lastMovementFrame = this.frameCnt;
        }
    }

    public void reset() {
        this.cmp.setCursor(null);
        this.lastMovementFrame = 0L;
        this.frameCnt = 0L;
    }
}

