/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.ui;

import java.io.FileReader;
import java.io.FileWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import omegadrive.SystemLoader;
import omegadrive.system.MediaSpecHolder;
import omegadrive.util.FileUtil;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public class PrefStore {
    protected static String PREF_FILENAME = "./helios.prefs";
    private static final Logger LOG = LogHelper.getLogger(PrefStore.class.getSimpleName());
    private static final String RECENT_FILE = "recent";
    private static final String UI_SWING_THEME = "helios.ui.swing.theme";
    public static final int recentFileTotal = 10;
    private static final Properties uiProperties = new Properties();
    public static String lastSaveFile = FileUtil.basePath;
    public static String lastRomFile = FileUtil.basePath;
    private static final Map<Integer, String> map = new LinkedHashMap<Integer, String>(10, 1.0f, true);
    private static int uiSwingThemeIndex = 0;

    public static void initPrefs() {
        uiProperties.clear();
        map.clear();
        try (FileReader reader = new FileReader(PREF_FILENAME);){
            uiProperties.load(reader);
        }
        catch (Exception e) {
            LOG.error("Unable to load properties file: {}", (Object)PREF_FILENAME);
        }
        finally {
            PrefStore.bootstrapIfNecessary();
        }
    }

    private static void bootstrapIfNecessary() {
        for (int i = 9; i >= 0; --i) {
            String key = "recent." + i;
            uiProperties.putIfAbsent(key, "");
            PrefStore.addRecentFile(uiProperties.getProperty(key));
        }
        uiProperties.putIfAbsent(UI_SWING_THEME, String.valueOf(uiSwingThemeIndex));
    }

    public static void addRecentFile(String path) {
        map.put(path.hashCode(), path);
        if (map.size() > 10) {
            Integer key = map.keySet().stream().findFirst().orElse(0);
            map.remove(key);
        }
    }

    public static List<String> getRecentFilesList() {
        ArrayList<String> l = new ArrayList<String>(map.values());
        Collections.reverse(l);
        return l;
    }

    public static MediaSpecHolder getRomSpecFromRecentItem(String text) {
        String file;
        SystemLoader.SystemType st;
        int idx = text.indexOf(44);
        int tknLimit = idx > 0 ? 2 : 0;
        String[] tkn = text.split(",", tknLimit);
        try {
            st = SystemLoader.SystemType.valueOf(PrefStore.getSystemStringFromRecentItem(text));
            file = tkn[1];
        }
        catch (Exception e) {
            st = SystemLoader.SystemType.NONE;
            file = tkn[0];
        }
        return MediaSpecHolder.of(Path.of(file, new String[0]), st);
    }

    public static String getSystemStringFromRecentItem(String text) {
        int tknLimit;
        String sys = SystemLoader.SystemType.NONE.name();
        int idx = text.indexOf(44);
        int n = tknLimit = idx > 0 ? 2 : 0;
        if (tknLimit == 0) {
            return sys;
        }
        try {
            String[] tkn = text.split(",", tknLimit);
            sys = tkn[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sys;
    }

    public static SystemLoader.SystemType getSystemTypeFromRecentItem(String text) {
        SystemLoader.SystemType st = SystemLoader.SystemType.NONE;
        try {
            st = SystemLoader.SystemType.valueOf(text);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return st;
    }

    public static int getSwingUiThemeIndex() {
        return Integer.parseInt(uiProperties.getProperty(UI_SWING_THEME));
    }

    public static void setSwingUiThemeIndex(int value) {
        uiSwingThemeIndex = value;
    }

    private static void toProps() {
        uiProperties.clear();
        List<String> l = PrefStore.getRecentFilesList();
        Iterator<String> it = l.iterator();
        for (int i = 0; i < l.size(); ++i) {
            String val = it.hasNext() ? it.next() : "";
            uiProperties.put("recent." + i, val);
        }
        uiProperties.setProperty(UI_SWING_THEME, String.valueOf(uiSwingThemeIndex));
    }

    public static void close() {
        try (FileWriter writer = new FileWriter(PREF_FILENAME);){
            PrefStore.toProps();
            uiProperties.store(writer, "");
            writer.flush();
        }
        catch (Exception e) {
            LOG.error("Unable to store to properties file: {}", (Object)PREF_FILENAME, (Object)e);
        }
    }
}

