/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.ui;

import java.awt.Dimension;

public class RenderingStrategy {
    private static final TransferFnHolder transferFnHolder = new TransferFnHolder();

    public static void subImageWithOffset(int[] src, int[] dest, Dimension srcDim, Dimension destDim, int xOffset, int yOffset) {
        int start = (yOffset + 1) * srcDim.width + xOffset + 1;
        int k = 0;
        int i = start;
        while (k < dest.length) {
            System.arraycopy(src, i, dest, k, destDim.width);
            k += destDim.width;
            i += srcDim.width;
        }
    }

    protected static void renderNearest(int[] srcPixels, int[] outputPixels, Dimension src, Dimension dest) {
        int factor = 16;
        int xRatio = (src.width << factor) / dest.width + 1;
        int yRatio = (src.height << factor) / dest.height + 1;
        for (int i = 0; i < dest.height; ++i) {
            int py = i * yRatio >> factor;
            int shiftDest = i * dest.width;
            int shiftSrc = py * src.width;
            for (int j = 0; j < dest.width; ++j) {
                int px = j * xRatio >> factor;
                outputPixels[shiftDest + j] = srcPixels[shiftSrc + px];
            }
        }
    }

    protected static void renderNearestNew(int[] srcPixels, int[] outputPixels, Dimension src, Dimension dest) {
        if (dest != RenderingStrategy.transferFnHolder.dest || src != RenderingStrategy.transferFnHolder.src) {
            System.out.println("recalc");
            RenderingStrategy.transferFnHolder.src = src;
            RenderingStrategy.transferFnHolder.dest = dest;
            RenderingStrategy.transferFnHolder.transferFn = new int[dest.height * dest.width];
            transferFnHolder.computeTransferFn();
        }
        int[] tFn = RenderingStrategy.transferFnHolder.transferFn;
        for (int i = 0; i < tFn.length; ++i) {
            outputPixels[i] = srcPixels[tFn[i]];
        }
    }

    static class TransferFnHolder {
        Dimension src = new Dimension(0, 0);
        Dimension dest = new Dimension(0, 0);
        int[] transferFn = new int[0];

        TransferFnHolder() {
        }

        protected void computeTransferFn() {
            int factor = 16;
            int xRatio = (this.src.width << factor) / this.dest.width + 1;
            int yRatio = (this.src.height << factor) / this.dest.height + 1;
            for (int i = 0; i < this.dest.height; ++i) {
                int py = i * yRatio >> factor;
                int shiftDest = i * this.dest.width;
                int shiftSrc = py * this.src.width;
                for (int j = 0; j < this.dest.width; ++j) {
                    int px = j * xRatio >> factor;
                    this.transferFn[shiftDest + j] = shiftSrc + px;
                }
            }
        }
    }
}

