/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.ui.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ObjectArrays;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import omegadrive.SystemLoader;
import omegadrive.system.SysUtil;

public class UiFileFilters {
    private static final Function<String[], String[]> removeExtensionDot = as -> (String[])Arrays.stream(as).map(s -> s.replace(".", "")).toArray(String[]::new);
    public static final String[] extBinaryTypesList = removeExtensionDot.apply(SysUtil.binaryTypes);
    private static Set<FileFilter> romFilterSet = new LinkedHashSet<FileFilter>();
    private static Map<String, SystemLoader.SystemType> romFilterDescMap = new HashMap<String, SystemLoader.SystemType>();
    public static final FileFilter SAVE_STATE_FILTER;
    public static final FileFilter ROM_FILTER;

    public static SystemLoader.SystemType getSystemTypeFromFilterDesc(FileResourceType resourceType, String desc, SystemLoader.SystemType current) {
        if (resourceType == FileResourceType.SAVE_STATE_RES) {
            return current;
        }
        return romFilterDescMap.getOrDefault(desc, SystemLoader.SystemType.NONE);
    }

    public static Set<FileFilter> getFilterSet(FileResourceType resourceType) {
        return switch (resourceType) {
            default -> throw new IncompatibleClassChangeError();
            case FileResourceType.ROM -> romFilterSet;
            case FileResourceType.SAVE_STATE_RES -> ImmutableSet.of((Object)SAVE_STATE_FILTER);
        };
    }

    static {
        FileNameExtensionFilter fn = new FileNameExtensionFilter(Arrays.toString(extBinaryTypesList) + " files", extBinaryTypesList);
        romFilterSet.add(fn);
        romFilterDescMap.put(fn.getDescription(), SystemLoader.SystemType.NONE);
        SysUtil.sysFileExtensionsMap.entrySet().stream().forEach(e -> {
            FileNameExtensionFilter fne = new FileNameExtensionFilter(((SystemLoader.SystemType)((Object)((Object)e.getKey()))).getShortName() + " files", removeExtensionDot.apply((String[])ObjectArrays.concat((Object[])((String[])e.getValue()), (Object[])SysUtil.compressedBinaryTypes, String.class)));
            romFilterSet.add(fne);
            romFilterDescMap.put(fne.getDescription(), (SystemLoader.SystemType)((Object)((Object)e.getKey())));
        });
        SAVE_STATE_FILTER = new FileFilter(){

            @Override
            public String getDescription() {
                return "state files";
            }

            @Override
            public boolean accept(File f) {
                String name = f.getName().toLowerCase();
                return f.isDirectory() || name.contains(".gs") || name.contains(".s0") || name.contains(".n0");
            }
        };
        ROM_FILTER = new FileNameExtensionFilter(Arrays.toString(extBinaryTypesList) + " files", extBinaryTypesList);
    }

    public static enum FileResourceType {
        ROM,
        SAVE_STATE_RES;

    }
}

