/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.util;

import com.google.common.math.IntMath;
import java.nio.ByteBuffer;
import omegadrive.Device;
import omegadrive.util.LogHelper;
import omegadrive.util.RegSpec;
import omegadrive.util.Size;
import omegadrive.util.Util;
import omegadrive.util.VideoMode;
import org.slf4j.Logger;
import s32x.S32XMMREG;
import s32x.dict.S32xDict;
import s32x.dict.Sh2Dict;

public class BufferUtil {
    private static final Logger LOG = LogHelper.getLogger(BufferUtil.class.getSimpleName());
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final boolean assertionsEnabled;
    public static final boolean ENFORCE_FM_BIT_ON_READS;

    public static void writeBuffers(ByteBuffer b1, ByteBuffer b2, int pos, int value, Size size) {
        BufferUtil.writeBufferRaw(b1, pos, value, size);
        BufferUtil.writeBufferRaw(b2, pos, value, size);
    }

    public static int readBufferRegLong(ByteBuffer b, Sh2Dict.RegSpecSh2 r) {
        return Util.readBufferLong(b, r.addr & 0x1FF);
    }

    public static void writeBufferLong(ByteBuffer b, Sh2Dict.RegSpecSh2 r, int value) {
        r.regSpec.write(b, value, Size.LONG);
    }

    public static void writeBufferLong(ByteBuffer b, int pos, int value) {
        Util.INT_BYTEBUF_HANDLE.set(b, pos, value);
    }

    public static void writeBuffersLong(ByteBuffer b, Sh2Dict.RegSpecSh2 r, Sh2Dict.RegSpecSh2 r1, Sh2Dict.RegSpecSh2 r2, int value) {
        r.regSpec.write(b, value, Size.LONG);
        r1.regSpec.write(b, value, Size.LONG);
        r2.regSpec.write(b, value, Size.LONG);
    }

    public static void writeBuffersLong(ByteBuffer b, Sh2Dict.RegSpecSh2 r, Sh2Dict.RegSpecSh2 r1, int value) {
        r.regSpec.write(b, value, Size.LONG);
        r1.regSpec.write(b, value, Size.LONG);
    }

    public static void writeRegBuffer(RegSpec r, ByteBuffer b, int value, Size size) {
        r.write(b, RegSpec.BytePosReg.BYTE_0, value, size);
    }

    public static void writeRegBuffer(RegSpec r, ByteBuffer b, int addr, int value, Size size) {
        r.write(b, addr, value, size);
    }

    public static void writeRegBuffer(Sh2Dict.RegSpecSh2 r, ByteBuffer b, int value, Size size) {
        BufferUtil.writeRegBuffer(r.regSpec, b, value, size);
    }

    public static boolean writeBufferRaw(ByteBuffer b, int pos, int value, Size size) {
        boolean changed = false;
        if (size == Size.WORD) {
            if (Util.SHORT_BYTEBUF_HANDLE.get(b, pos) != value) {
                Util.SHORT_BYTEBUF_HANDLE.set(b, pos, (short)value);
                changed = true;
            }
        } else if (size == Size.LONG) {
            if (Util.INT_BYTEBUF_HANDLE.get(b, pos) != value) {
                Util.INT_BYTEBUF_HANDLE.set(b, pos, value);
                changed = true;
            }
        } else if (size == Size.BYTE && b.get(pos) != value) {
            b.put(pos, (byte)value);
            changed = true;
        }
        return changed;
    }

    public static int readBuffer(ByteBuffer b, int pos, Size size) {
        return switch (size) {
            default -> throw new IncompatibleClassChangeError();
            case Size.WORD -> Util.readBufferWord(b, pos);
            case Size.LONG -> Util.readBufferLong(b, pos);
            case Size.BYTE -> Util.readBufferByte(b, pos);
        };
    }

    public static void setBit(ByteBuffer b1, ByteBuffer b2, int pos, int bitPos, int bitValue, Size size) {
        BufferUtil.setBit(b1, pos, bitPos, bitValue, size);
        BufferUtil.setBit(b2, pos, bitPos, bitValue, size);
    }

    public static boolean setBit(ByteBuffer b, int pos, int bitPos, int bitValue, Size size) {
        int newVal;
        assert ((bitValue & 1) == bitValue);
        int val = BufferUtil.readBuffer(b, pos, size);
        if (val != (newVal = Util.setBit(val, bitPos, bitValue))) {
            BufferUtil.writeBufferRaw(b, pos, newVal, size);
            return true;
        }
        return false;
    }

    public static int setBitVal(ByteBuffer b, int pos, int bitPos, int bitValue, Size size) {
        int newVal;
        int val = BufferUtil.readBuffer(b, pos, size);
        if (val != (newVal = Util.setBit(val, bitPos, bitValue))) {
            BufferUtil.writeBufferRaw(b, pos, newVal, size);
            return newVal;
        }
        return val;
    }

    public static int readWordFromBuffer(S32XMMREG.RegContext ctx, S32xDict.RegSpecS32x reg) {
        return BufferUtil.readBufferReg(ctx, reg, reg.addr, Size.WORD);
    }

    public static int readBufferReg(S32XMMREG.RegContext ctx, S32xDict.RegSpecS32x reg, int address, Size size) {
        address &= reg.getAddrMask();
        if (reg.deviceType == S32xDict.S32xRegType.VDP) {
            return BufferUtil.readBuffer(ctx.vdpRegs, address, size);
        }
        switch (reg.regCpuType) {
            case REG_BOTH: {
                assert (BufferUtil.readBuffer(ctx.sysRegsMd, address, size) == BufferUtil.readBuffer(ctx.sysRegsSh2, address, size));
            }
            case REG_MD: {
                return BufferUtil.readBuffer(ctx.sysRegsMd, address, size);
            }
            case REG_SH2: {
                return BufferUtil.readBuffer(ctx.sysRegsSh2, address, size);
            }
        }
        LOG.error("Unable to read buffer: {}, addr: {} {}", new Object[]{reg.getName(), Util.th(address), size});
        return size.getMask();
    }

    public static boolean setBitRegFromWord(ByteBuffer bb, S32xDict.RegSpecS32x reg, int pos, int value) {
        return BufferUtil.setBit(bb, reg.addr, pos, value, Size.WORD);
    }

    public static void setBitReg(S32XMMREG.RegContext rc, S32xDict.RegSpecS32x reg, int address, int pos, int value, Size size) {
        address &= reg.getAddrMask();
        if (reg.deviceType == S32xDict.S32xRegType.VDP) {
            BufferUtil.setBit(rc.vdpRegs, address, pos, value, size);
            return;
        }
        switch (reg.regCpuType) {
            case REG_BOTH: {
                BufferUtil.setBit(rc.sysRegsMd, rc.sysRegsSh2, address, pos, value, size);
                break;
            }
            case REG_MD: {
                BufferUtil.setBit(rc.sysRegsMd, address, pos, value, size);
                break;
            }
            case REG_SH2: {
                BufferUtil.setBit(rc.sysRegsSh2, address, pos, value, size);
                break;
            }
            default: {
                LOG.error("Unable to setBit: {}, addr: {}, value: {} {}", new Object[]{reg.getName(), Util.th(address), Util.th(value), size});
            }
        }
    }

    public static void writeBufferReg(S32XMMREG.RegContext rc, S32xDict.RegSpecS32x reg, int address, int value, Size size) {
        address &= reg.getAddrMask();
        if (reg.deviceType == S32xDict.S32xRegType.VDP) {
            reg.regSpec.write(rc.vdpRegs, address, value, size);
            return;
        }
        switch (reg.regCpuType) {
            case REG_BOTH: {
                BufferUtil.writeRegBuffer(reg.regSpec, rc.sysRegsMd, address, value, size);
                BufferUtil.writeRegBuffer(reg.regSpec, rc.sysRegsSh2, address, value, size);
                break;
            }
            case REG_MD: {
                BufferUtil.writeRegBuffer(reg.regSpec, rc.sysRegsMd, address, value, size);
                break;
            }
            case REG_SH2: {
                BufferUtil.writeRegBuffer(reg.regSpec, rc.sysRegsSh2, address, value, size);
                break;
            }
            default: {
                LOG.error("Unable to write buffer: {}, addr: {}, value: {} {}", new Object[]{reg.getName(), Util.th(address), Util.th(value), size});
            }
        }
    }

    public static String toHexString(ByteBuffer b, int pos, Size size) {
        return Integer.toHexString(BufferUtil.readBuffer(b, pos, size));
    }

    public static void assertPowerOf2Minus1(String name, int value) {
        if (!IntMath.isPowerOfTwo((int)(value + 1))) {
            LOG.error("{} should be a (powerOf2 - 1), ie. 0xFF, actual: {}", (Object)name, (Object)Util.th(value - 1));
        }
        assert (IntMath.isPowerOfTwo((int)(value + 1))) : name + " should be a (powerOf2 - 1), ie. 0xFF, actual: " + Util.th(value - 1);
    }

    public static void vidH32StretchToH40(VideoMode srcv, int[] src, int[] dest) {
        assert (dest.length > src.length);
        assert (srcv.getDimension().height * srcv.getDimension().width == src.length);
        assert (srcv.getDimension().height * 320 == dest.length);
        int k = 0;
        int h = srcv.getDimension().height;
        int w = srcv.getDimension().width;
        for (int i = 0; i < h; ++i) {
            int base = i * w;
            for (int j = 0; j < w; j += 4) {
                dest[k++] = src[base + j];
                dest[k++] = src[base + j + 1];
                dest[k++] = src[base + j + 2];
                dest[k++] = src[base + j + 3];
                dest[k++] = src[base + j + 3];
            }
        }
    }

    public static int hashCode(int[] a, int len) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (int i = 0; i < len; ++i) {
            result = 31 * result + a[i];
        }
        return result;
    }

    static {
        boolean res = false;
        if (!$assertionsDisabled) {
            res = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        ENFORCE_FM_BIT_ON_READS = assertionsEnabled = res;
    }

    public static enum CpuDeviceAccess {
        MASTER("SHM"),
        SLAVE("SHS"),
        M68K("68M"),
        Z80("Z80"),
        SUB_M68K("68S");

        public final S32xRegSide regSide = this.ordinal() < 2 ? S32xRegSide.SH2 : S32xRegSide.MD;
        public final String cpuShortCode;
        public static final CpuDeviceAccess[] cdaValues;

        private CpuDeviceAccess(String code) {
            this.cpuShortCode = code;
        }

        public static CpuDeviceAccess fromCpuCode(String code) {
            for (CpuDeviceAccess c : cdaValues) {
                if (!code.equals(c.cpuShortCode)) continue;
                return c;
            }
            LOG.error("Unknown cpu code: {}", (Object)code);
            return null;
        }

        static {
            cdaValues = CpuDeviceAccess.values();
        }
    }

    public static enum S32xRegSide {
        MD,
        SH2;

    }

    public static interface Sh2Device
    extends StepDevice {
        public void write(Sh2Dict.RegSpecSh2 var1, int var2, int var3, Size var4);

        public int read(Sh2Dict.RegSpecSh2 var1, int var2, Size var3);

        default public void write(Sh2Dict.RegSpecSh2 regSpec, int value, Size size) {
            this.write(regSpec, regSpec.addr, value, size);
        }

        default public int read(Sh2Dict.RegSpecSh2 regSpec, Size size) {
            return this.read(regSpec, regSpec.addr, size);
        }
    }

    public static interface StepDevice
    extends Device {
        default public void step(int cycles) {
        }
    }
}

