/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.util;

import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageUtil {
    public static BufferedImage createImage(GraphicsDevice gd, Dimension d) {
        BufferedImage bi = gd.getDefaultConfiguration().createCompatibleImage(d.width, d.height);
        if (bi.getType() != 1) {
            bi = new BufferedImage(d.width, d.height, 1);
        }
        return bi;
    }

    public static int[] getPixels(BufferedImage img) {
        return ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
    }

    public static BufferedImage loadImageFromFile(File file) {
        try {
            return ImageIO.read(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void saveImageToFile(RenderedImage image, File file, String ext) {
        try {
            boolean res = ImageIO.write(image, ext, file);
            if (!res) {
                throw new IOException("Unable to find an image writer");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveImageToFile(RenderedImage image, File file) {
        ImageUtil.saveImageToFile(image, file, "jpg");
    }
}

