/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.util;

import omegadrive.SystemLoader;
import omegadrive.system.SystemProvider;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;
import s32x.Md32x;
import s32x.sh2.Sh2Helper;

public class MdRuntimeData {
    private static final Logger LOG = LogHelper.getLogger(Md32x.class.getSimpleName());
    private BufferUtil.CpuDeviceAccess accessType = BufferUtil.CpuDeviceAccess.MASTER;
    private int accType = this.accessType.ordinal();
    private final int[] cpuDelay = new int[BufferUtil.CpuDeviceAccess.cdaValues.length];
    private final boolean ignoreDelays;
    private final SystemLoader.SystemType type;
    private final SystemProvider.SystemClock clock;
    private static MdRuntimeData rt;

    private MdRuntimeData(SystemLoader.SystemType type, SystemProvider.SystemClock clock) {
        this.type = type;
        this.clock = clock;
        boolean id = false;
        if (type == SystemLoader.SystemType.S32X) {
            id = Sh2Helper.Sh2Config.get().ignoreDelays;
        }
        this.ignoreDelays = id;
    }

    public static MdRuntimeData newInstance(SystemLoader.SystemType type, SystemProvider.SystemClock clock) {
        MdRuntimeData mrt;
        if (rt != null) {
            LOG.error("Previous instance has not been released! {}", (Object)MdRuntimeData.rt.type);
        }
        rt = mrt = new MdRuntimeData(type, clock);
        return mrt;
    }

    public static MdRuntimeData releaseInstance() {
        MdRuntimeData m = rt;
        rt = null;
        return m;
    }

    public final void addCpuDelay(int delay) {
        int n = this.accType;
        this.cpuDelay[n] = this.cpuDelay[n] + delay;
    }

    public final int resetCpuDelay() {
        int res = this.cpuDelay[this.accType];
        this.cpuDelay[this.accType] = 0;
        return res;
    }

    public void setAccessType(BufferUtil.CpuDeviceAccess accessType) {
        this.accessType = accessType;
        this.accType = accessType.ordinal();
    }

    protected BufferUtil.CpuDeviceAccess getAccessType() {
        return this.accessType;
    }

    public static void addCpuDelayExt(int delay) {
        rt.addCpuDelay(delay);
    }

    public static void addCpuDelayExt(int[][] delays, int deviceType) {
        rt.addCpuDelay(delays[MdRuntimeData.rt.accType][deviceType]);
    }

    public static BufferUtil.CpuDeviceAccess setAccessTypeExt(BufferUtil.CpuDeviceAccess accessType) {
        BufferUtil.CpuDeviceAccess prev = MdRuntimeData.rt.accessType;
        MdRuntimeData.rt.accessType = accessType;
        MdRuntimeData.rt.accType = accessType.ordinal();
        return prev;
    }

    public static int resetCpuDelayExt(int value) {
        int res = MdRuntimeData.rt.cpuDelay[MdRuntimeData.rt.accType];
        MdRuntimeData.rt.cpuDelay[MdRuntimeData.rt.accType] = value;
        return MdRuntimeData.rt.ignoreDelays ? 0 : res;
    }

    public static void resetCpuDelayExt(BufferUtil.CpuDeviceAccess cpu, int value) {
        MdRuntimeData.rt.cpuDelay[cpu.ordinal()] = value;
    }

    public static void resetAllCpuDelayExt() {
        for (BufferUtil.CpuDeviceAccess v : BufferUtil.CpuDeviceAccess.cdaValues) {
            MdRuntimeData.rt.cpuDelay[v.ordinal()] = 0;
        }
    }

    public static int resetCpuDelayExt() {
        return MdRuntimeData.resetCpuDelayExt(0);
    }

    public static int getCpuDelayExt() {
        return MdRuntimeData.rt.cpuDelay[MdRuntimeData.rt.accType];
    }

    public static int getCpuDelayExt(BufferUtil.CpuDeviceAccess cpu) {
        return MdRuntimeData.rt.cpuDelay[cpu.ordinal()];
    }

    public static BufferUtil.CpuDeviceAccess getAccessTypeExt() {
        return MdRuntimeData.rt.accessType;
    }

    public static SystemProvider.SystemClock getSystemClockExt() {
        return MdRuntimeData.rt.clock;
    }
}

