/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class PriorityThreadFactory
implements ThreadFactory {
    private final AtomicInteger threadNumber = new AtomicInteger();
    private final String namePrefix;
    private final int threadPriority;

    public PriorityThreadFactory(int priority, Object className) {
        this(priority, className.getClass().getSimpleName());
    }

    public PriorityThreadFactory(int priority, String namePrefix) {
        this.namePrefix = namePrefix;
        this.threadPriority = priority;
    }

    public PriorityThreadFactory(String namePrefix) {
        this(5, namePrefix);
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, this.namePrefix + "-" + this.threadNumber.getAndIncrement());
        t.setPriority(this.threadPriority);
        return t;
    }
}

