/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.util;

import java.awt.Dimension;
import omegadrive.util.VideoMode;

public class ScreenSizeHelper {
    public static final double FOUR_BY_THREE = 1.3333333333333333;
    public static final int DEFAULT_X = Integer.parseInt(System.getProperty("helios.default", "320"));
    public static final int DEFAULT_Y = 256;
    public static final int DEFAULT_SCALE_FACTOR = Integer.parseInt(System.getProperty("helios.ui.scale", "2"));
    public static final double FULL_SCREEN_WITH_TITLE_BAR_FACTOR = Double.parseDouble(System.getProperty("helios.ui.fsTitle.factor", "1"));
    public static final boolean FIX_ASPECT_RATIO = Boolean.parseBoolean(System.getProperty("helios.ui.fix.aspect.ratio", "true"));
    public static final boolean INTEGER_SCALING = Boolean.parseBoolean(System.getProperty("helios.ui.integer.scaling", "true"));
    public static final Dimension DEFAULT_SCALED_SCREEN_SIZE = new Dimension(DEFAULT_X * DEFAULT_SCALE_FACTOR, 256 * DEFAULT_SCALE_FACTOR);
    public static final Dimension DEFAULT_BASE_SCREEN_SIZE = new Dimension(DEFAULT_X, 256);
    public static final Dimension DEFAULT_FRAME_SIZE = new Dimension((int)((double)ScreenSizeHelper.DEFAULT_SCALED_SCREEN_SIZE.width * 1.02), (int)((double)ScreenSizeHelper.DEFAULT_SCALED_SCREEN_SIZE.height * 1.1));

    public static Dimension getScreenSize(VideoMode videoMode, double multiplier, boolean keepAspectRatio) {
        return ScreenSizeHelper.getScreenSize(videoMode.getDimension(), multiplier, keepAspectRatio);
    }

    public static Dimension getScreenSize(Dimension src, double multiplier, boolean keepAspectRatio) {
        Dimension dim = src;
        if (keepAspectRatio || multiplier != 1.0) {
            double w = (double)src.width * multiplier;
            double h = w / 1.3333333333333333;
            dim = new Dimension((int)w, (int)h);
        }
        return dim;
    }

    public static double getFullScreenScaleFactor(Dimension fullScreenSize, Dimension nativeScreenSize) {
        double scaleW = fullScreenSize.getWidth() / nativeScreenSize.getWidth();
        double baseH = nativeScreenSize.getHeight();
        baseH = FIX_ASPECT_RATIO ? nativeScreenSize.getWidth() / 1.3333333333333333 : baseH;
        double scaleH = fullScreenSize.getHeight() * FULL_SCREEN_WITH_TITLE_BAR_FACTOR / baseH;
        double res = Math.min(scaleW, scaleH);
        return INTEGER_SCALING ? Math.floor(res) : res;
    }
}

