/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import omegadrive.sound.SoundProvider;
import omegadrive.util.LogHelper;
import omegadrive.util.Sleeper;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class SoundUtil {
    private static final Logger LOG;
    public static final byte ZERO_BYTE = 0;
    private static final int DEFAULT_PSG_SHIFT_BITS = 6;
    public static final double PSG_ATTENUATION;
    private static final int USER_PSG_ATT_BITS;
    private static final int PSG_SHIFT_BITS;

    public static int writeBufferInternal(SourceDataLine line, byte[] buffer, int start, int end) {
        int res = 0;
        try {
            res = line.write(buffer, start, end);
            if (res < end - start) {
                LOG.warn("bytes written: {}/{}", (Object)res, (Object)(end - start));
            }
        }
        catch (IllegalArgumentException iae) {
            LOG.error("Error writing to the audio line. The bytes do not represent complete frames.");
        }
        catch (ArrayIndexOutOfBoundsException aiobe) {
            LOG.error("Error writing to the audio line. The buffer does not contain the number of bytes specified.");
        }
        return res;
    }

    public static int writeBufferInternal(SourceDataLine line, byte[] buffer, int samplesPerFrame) {
        return SoundUtil.writeBufferInternal(line, buffer, 0, samplesPerFrame);
    }

    private static long millis2bytes(AudioFormat format, long millis) {
        long result = (long)((float)millis * format.getFrameRate() / 1000.0f * (float)format.getFrameSize());
        return SoundUtil.align(result, format.getFrameSize());
    }

    static long align(long bytes, int blockSize) {
        if (blockSize <= 1) {
            return bytes;
        }
        return bytes - bytes % (long)blockSize;
    }

    public static int getAudioLineBufferSize(AudioFormat audioFormat) {
        return (int)SoundUtil.millis2bytes(audioFormat, SoundProvider.AUDIO_BUFFER_LEN_MS);
    }

    public static int getMonoSamplesBufferSize(AudioFormat audioFormat) {
        return SoundUtil.getAudioLineBufferSize(audioFormat) / audioFormat.getFrameSize();
    }

    public static int getSamplesBufferSize(AudioFormat audioFormat, int millis) {
        return (int)SoundUtil.millis2bytes(audioFormat, millis);
    }

    public static int getMonoSamplesBufferSize(AudioFormat audioFormat, int millis) {
        return (int)SoundUtil.millis2bytes(audioFormat, millis) / audioFormat.getFrameSize();
    }

    public static int getStereoSamplesBufferSize(AudioFormat audioFormat) {
        return SoundUtil.getMonoSamplesBufferSize(audioFormat) << 1;
    }

    public static SourceDataLine createDataLine(AudioFormat audioFormat) {
        SourceDataLine line = null;
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        if (!AudioSystem.isLineSupported(info)) {
            LOG.error("Audio not supported...");
        } else {
            try {
                line = (SourceDataLine)AudioSystem.getLine(info);
                int bufSize = SoundUtil.getAudioLineBufferSize(audioFormat);
                line.open(audioFormat, bufSize);
                SoundUtil.lowerLatencyHack(line);
                line.start();
                LOG.info("SourceDataLine buffer: {} ms, {} bytes, actual: {} bytes", new Object[]{SoundProvider.AUDIO_BUFFER_LEN_MS, bufSize, line.getBufferSize()});
            }
            catch (LineUnavailableException lue) {
                LOG.error("Unable to open audio line.");
            }
        }
        return line;
    }

    private static void lowerLatencyHack(SourceDataLine line) {
        String sname = line.getClass().getSuperclass().getCanonicalName();
        if (Sleeper.isWindows() && "com.sun.media.sound.DirectAudioDevice.DirectDL".equalsIgnoreCase(sname)) {
            try {
                Field f = line.getClass().getSuperclass().getDeclaredField("waitTime");
                f.setAccessible(true);
                f.set(line, 1);
                LOG.info("Setting waitTime to 1ms for SourceDataLine: {}", (Object)line.getClass().getCanonicalName());
            }
            catch (Exception e) {
                LOG.warn("Unable to set waitTime for SourceDataLine: {}", (Object)line.getClass().getCanonicalName());
            }
        }
    }

    public static void intStereo16ToByteStereo16Mix(int[] input, byte[] output, int inputLen) {
        int i = 0;
        int k = 0;
        while (i < inputLen) {
            output[k] = (byte)(input[i] & 0xFF);
            output[k + 1] = (byte)(input[i] >> 8 & 0xFF);
            output[k + 2] = (byte)(input[i + 1] & 0xFF);
            output[k + 3] = (byte)(input[i + 1] >> 8 & 0xFF);
            i += 2;
            k += 4;
        }
    }

    public static void intStereo14ToByteStereo16PwmMix(byte[] output, int[] fmStereo16, int[] pwmStereo16, byte[] psgMono8, int inputLen) {
        int j = 0;
        int k = 0;
        int i = 0;
        while (i < inputLen) {
            int psg = psgMono8[j];
            int out16L = fmStereo16[i] + pwmStereo16[i] + (psg <<= 6);
            int out16R = fmStereo16[i + 1] + pwmStereo16[i + 1] + psg;
            out16L = Math.min(Math.max(out16L, Short.MIN_VALUE), Short.MAX_VALUE);
            out16R = Math.min(Math.max(out16R, Short.MIN_VALUE), Short.MAX_VALUE);
            output[k] = (byte)(out16L & 0xFF);
            output[k + 1] = (byte)(out16L >> 8 & 0xFF);
            output[k + 2] = (byte)(out16R & 0xFF);
            output[k + 3] = (byte)(out16R >> 8 & 0xFF);
            i += 2;
            ++j;
            k += 4;
        }
    }

    public static void intStereo14ToByteStereo16Mix(int[] input, byte[] output, byte[] psgMono8, int inputLen) {
        int j = 0;
        int k = 0;
        int i = 0;
        while (i < inputLen) {
            int psg = psgMono8[j];
            psg = PSG_SHIFT_BITS > 0 ? psg << PSG_SHIFT_BITS : psg >> -PSG_SHIFT_BITS;
            int out16L = input[i] + psg;
            int out16R = input[i + 1] + psg;
            out16L = (out16L << 1) - (out16L >> 1);
            out16R = (out16R << 1) - (out16R >> 1);
            out16L = Math.min(Math.max(out16L, Short.MIN_VALUE), Short.MAX_VALUE);
            out16R = Math.min(Math.max(out16R, Short.MIN_VALUE), Short.MAX_VALUE);
            output[k] = (byte)(out16L & 0xFF);
            output[k + 1] = (byte)(out16L >> 8 & 0xFF);
            output[k + 2] = (byte)(out16R & 0xFF);
            output[k + 3] = (byte)(out16R >> 8 & 0xFF);
            i += 2;
            ++j;
            k += 4;
        }
    }

    public static void intStereo14ToByteStereo16MixFloat(int[] input, float[] output, byte[] psgMono8, int inputLen) {
        int j = 0;
        int k = 0;
        int i = 0;
        while (i < inputLen) {
            int psg = psgMono8[j];
            psg = PSG_SHIFT_BITS > 0 ? psg << PSG_SHIFT_BITS : psg >> -PSG_SHIFT_BITS;
            int out16L = input[i] + psg;
            int out16R = input[i + 1] + psg;
            out16L = (out16L << 1) - out16L;
            out16R = (out16R << 1) - out16R;
            out16L = Math.min(Math.max(out16L, Short.MIN_VALUE), Short.MAX_VALUE);
            out16R = Math.min(Math.max(out16R, Short.MIN_VALUE), Short.MAX_VALUE);
            output[k] = (float)out16L / 32768.0f;
            output[k + 1] = (float)out16R / 32768.0f;
            i += 2;
            ++j;
            k += 2;
        }
    }

    public static void byteMono8ToByteStereo16Mix(byte[] psgMono8, byte[] output) {
        int j = 0;
        int i = 0;
        while (j < psgMono8.length) {
            int psg16 = psgMono8[j] << 7;
            output[i] = (byte)(psg16 & 0xFF);
            output[i + 1] = (byte)(psg16 >> 8 & 0xFF);
            output[i + 2] = output[i];
            output[i + 3] = output[i + 1];
            ++j;
            i += 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(DataLine line) {
        if (line != null) {
            line.stop();
            DataLine dataLine = line;
            synchronized (dataLine) {
                line.flush();
            }
            Util.sleep(150L);
            line.close();
            Util.sleep(100L);
        }
    }

    public static void convertToWav(AudioFormat audioFormat, String fileName) {
        File input = new File(fileName);
        File output = new File(fileName + ".wav");
        try (FileInputStream fileInputStream = new FileInputStream(input);
             AudioInputStream audioInputStream = new AudioInputStream(fileInputStream, audioFormat, input.length());){
            AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, output);
            audioInputStream.close();
            LOG.info("{} saved", (Object)output.getAbsolutePath());
        }
        catch (IOException ioe) {
            LOG.error("Error writing WAV file: {}", (Object)output.getAbsolutePath());
            ioe.printStackTrace();
            System.out.println("Error writing WAV file");
        }
    }

    static {
        int shift;
        LOG = LogHelper.getLogger(SoundUtil.class.getSimpleName());
        PSG_ATTENUATION = Double.parseDouble(System.getProperty("sound.psg.attenuation", "1.0"));
        double res = 4.0;
        for (shift = -2; res > PSG_ATTENUATION && shift < 16; res /= 2.0, ++shift) {
        }
        USER_PSG_ATT_BITS = shift;
        PSG_SHIFT_BITS = 6 - USER_PSG_ATT_BITS;
        LOG.info("PSG attenuation: {}, in bits: {}", (Object)PSG_ATTENUATION, (Object)USER_PSG_ATT_BITS);
    }
}

