/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.util;

import java.awt.Dimension;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import omegadrive.util.LogHelper;
import omegadrive.util.RegionDetector;
import org.slf4j.Logger;

public enum VideoMode {
    PAL_H40_V30(RegionDetector.Region.EUROPE, 320, 240),
    PAL_H40_V28(RegionDetector.Region.EUROPE, 320, 224),
    PAL_H32_V30(RegionDetector.Region.EUROPE, 256, 240),
    PAL_H32_V28(RegionDetector.Region.EUROPE, 256, 224),
    NTSCU_H32_V28(RegionDetector.Region.USA, 256, 224),
    NTSCJ_H32_V28(RegionDetector.Region.JAPAN, 256, 224),
    NTSCU_H32_V30(RegionDetector.Region.USA, 256, 240),
    NTSCJ_H32_V30(RegionDetector.Region.JAPAN, 256, 240),
    NTSCU_H40_V28(RegionDetector.Region.USA, 320, 224),
    NTSCJ_H40_V28(RegionDetector.Region.JAPAN, 320, 224),
    NTSCU_H40_V30(RegionDetector.Region.USA, 320, 240),
    NTSCJ_H40_V30(RegionDetector.Region.JAPAN, 320, 240),
    NTSCJ_H32_V24(RegionDetector.Region.JAPAN, 256, 192),
    NTSCU_H32_V24(RegionDetector.Region.USA, 256, 192),
    PAL_H32_V24(RegionDetector.Region.EUROPE, 256, 192),
    NTSCJ_H20_V18(RegionDetector.Region.JAPAN, 160, 144),
    NTSCU_H20_V18(RegionDetector.Region.USA, 160, 144),
    PAL_H20_V18(RegionDetector.Region.EUROPE, 160, 144),
    NTSCU_H32_V32(RegionDetector.Region.USA, 256, 256);

    private static final Logger LOG;
    private static final Set<VideoMode> values;
    private final RegionDetector.Region region;
    private final int h;
    private final int v;
    private final Dimension dimension;

    private VideoMode(RegionDetector.Region region, int h, int v) {
        this.h = h;
        this.v = v;
        this.region = region;
        this.dimension = new Dimension(h, v);
    }

    public boolean isPal() {
        return this.region == RegionDetector.Region.EUROPE;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public RegionDetector.Region getRegion() {
        return this.region;
    }

    public boolean isH32() {
        return this.h == 256;
    }

    public boolean isH40() {
        return this.h == 320;
    }

    public boolean isV28() {
        return this.v == 224;
    }

    public boolean isV30() {
        return this.v == 240;
    }

    public boolean isV24() {
        return this.v == 192;
    }

    public static VideoMode getVideoMode(RegionDetector.Region region, boolean isH40, boolean isV30, VideoMode currentMode) {
        int hMode = isH40 ? 320 : 256;
        int vMode = isV30 ? 240 : 224;
        for (VideoMode m : values) {
            if (m.region != region || m.v != vMode || m.h != hMode) continue;
            return m;
        }
        LOG.error("Unable to find videoMode for: {}, isH40: {}, isV30: {}", new Object[]{region, isH40, isV30});
        return currentMode;
    }

    static {
        LOG = LogHelper.getLogger(VideoMode.class.getSimpleName());
        values = new HashSet<VideoMode>(EnumSet.allOf(VideoMode.class));
    }
}

