/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp;

import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.file.Path;
import java.nio.file.Paths;
import omegadrive.util.ImageUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.VideoMode;
import omegadrive.vdp.model.VdpMisc;
import org.slf4j.Logger;

public class VdpRenderDump {
    private static final Logger LOG = LogHelper.getLogger(VdpRenderDump.class.getSimpleName());
    public static GraphicsDevice gd;
    static final boolean isHeadless;
    private final Path folder = Paths.get(".", "screencap");
    private int[] pixels = new int[0];
    private BufferedImage bi;

    public VdpRenderDump() {
        if (!isHeadless) {
            this.bi = gd.getDefaultConfiguration().createCompatibleImage(1, 1);
        }
    }

    public void saveRenderToFile(int[] data, VideoMode videoMode, VdpMisc.RenderType type) {
        if (isHeadless) {
            LOG.warn("Not supported in headless mode");
            return;
        }
        long now = System.currentTimeMillis();
        String fileName = type.toString() + "_" + now + ".jpg";
        this.bi = this.getImage(videoMode);
        System.arraycopy(data, 0, this.pixels, 0, data.length);
        this.saveImageToFile(this.bi, fileName);
    }

    private void saveImageToFile(BufferedImage bi, String fileName) {
        Path file = Paths.get(this.folder.toAbsolutePath().toString(), fileName);
        LOG.info("Saving render to: {}", (Object)file.toAbsolutePath());
        ImageUtil.saveImageToFile(bi, file.toFile());
    }

    private static int[] getPixels(BufferedImage img) {
        return ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
    }

    public BufferedImage getImage(VideoMode videoMode) {
        Dimension d = videoMode.getDimension();
        if (this.bi.getWidth() * this.bi.getHeight() != d.width * d.height) {
            this.bi = gd.getDefaultConfiguration().createCompatibleImage(d.width, d.height);
            this.pixels = VdpRenderDump.getPixels(this.bi);
        }
        return this.bi;
    }

    static {
        isHeadless = GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance();
        if (!isHeadless) {
            gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        }
    }
}

