/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp.md;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.stream.IntStream;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import omegadrive.vdp.md.VdpColorMapper;
import omegadrive.vdp.model.MdVdpProvider;
import omegadrive.vdp.model.VdpMemoryInterface;
import org.slf4j.Logger;

public class MdVdpMemoryInterface
implements VdpMemoryInterface {
    public static final boolean verbose = false;
    private static final Logger LOG = LogHelper.getLogger(MdVdpMemoryInterface.class.getSimpleName());
    private static final int EVEN_VALUE_MASK = -2;
    private ByteBuffer vram;
    private ByteBuffer cram;
    private ByteBuffer vsram;
    private int[] javaPalette;
    private final int[] satCache = new int[640];
    private int satBaseAddress = 0;
    private int satEndAddress = this.satBaseAddress + this.satCache.length;
    private final VdpColorMapper colorMapper = VdpColorMapper.getInstance();

    protected MdVdpMemoryInterface() {
    }

    public static MdVdpMemoryInterface createInstance() {
        MdVdpMemoryInterface i = new MdVdpMemoryInterface();
        i.init();
        return i;
    }

    protected void init() {
        this.vram = Util.initMemoryRandomBytes(ByteBuffer.allocate(65536).order(ByteOrder.BIG_ENDIAN));
        this.cram = Util.initMemoryRandomBytes(ByteBuffer.allocate(128).order(ByteOrder.BIG_ENDIAN));
        this.vsram = Util.initMemoryRandomBytes(ByteBuffer.allocate(80).order(ByteOrder.BIG_ENDIAN));
        this.initPalette();
    }

    private void paletteUpdate(int cramAddress) {
        this.javaPalette[cramAddress >> 1] = this.colorMapper.getColor(Util.readBufferWord(this.cram, cramAddress));
    }

    private void initPalette() {
        this.javaPalette = new int[this.cram.capacity() / 2];
        IntStream.range(0, this.javaPalette.length).forEach(i -> this.paletteUpdate(i << 1));
    }

    protected byte readVramByte(int address) {
        return this.vram.get(address & 0xFFFF);
    }

    protected void writeVramByte(int address, byte data) {
        this.vram.put(address & 0xFFFF, data);
        this.updateSatCache(address, data);
    }

    @Override
    public int readVideoRamWord(MdVdpProvider.VdpRamType vramType, int address) {
        switch (vramType) {
            case VRAM: {
                return this.readVramWord(address);
            }
            case VSRAM: {
                return this.readVsramWord(address);
            }
            case CRAM: {
                return this.readCramWord(address);
            }
        }
        LOG.warn("Unexpected videoRam read: {}", (Object)vramType);
        return 0;
    }

    @Override
    public void writeVideoRamWord(MdVdpProvider.VdpRamType vramType, int data, int address) {
        byte data1 = (byte)(data >> 8);
        byte data2 = (byte)data;
        int index = address & 0xFFFFFFFE;
        switch (vramType) {
            case VRAM: {
                boolean byteSwap = (address & 1) == 1;
                this.writeVramByte(index, byteSwap ? data2 : data1);
                this.writeVramByte(index + 1, byteSwap ? data1 : data2);
                break;
            }
            case VSRAM: {
                this.writeVsramByte(index, data1);
                this.writeVsramByte(index + 1, data2);
                break;
            }
            case CRAM: {
                this.writeCramByte(index, data1);
                this.writeCramByte(index + 1, data2);
                break;
            }
            default: {
                LOG.warn("Unexpected videoRam write: {}", (Object)vramType);
            }
        }
    }

    @Override
    public void writeVideoRamByte(MdVdpProvider.VdpRamType vramType, int address, byte data) {
        switch (vramType) {
            case VRAM: {
                this.writeVramByte(address, data);
                break;
            }
            case CRAM: {
                this.writeCramByte(address, data);
                break;
            }
            case VSRAM: {
                this.writeVsramByte(address, data);
            }
        }
    }

    @Override
    public byte readVideoRamByte(MdVdpProvider.VdpRamType vramType, int address) {
        return switch (vramType) {
            default -> throw new IncompatibleClassChangeError();
            case MdVdpProvider.VdpRamType.VRAM -> this.readVramByte(address);
            case MdVdpProvider.VdpRamType.CRAM -> this.readCramByte(address);
            case MdVdpProvider.VdpRamType.VSRAM -> this.readVsramByte(address);
        };
    }

    private void updateSatCache(int vramAddress, byte value) {
        if (vramAddress >= this.satBaseAddress && vramAddress < this.satEndAddress) {
            this.satCache[vramAddress - this.satBaseAddress] = value & 0xFF;
        }
    }

    @Override
    public void setSatBaseAddress(int satBaseAddress) {
        this.satBaseAddress = satBaseAddress;
        this.satEndAddress = satBaseAddress + this.satCache.length;
    }

    @Override
    public int[] getSatCache() {
        return this.satCache;
    }

    @Override
    public ByteBuffer getCram() {
        return this.cram;
    }

    @Override
    public ByteBuffer getVram() {
        return this.vram;
    }

    @Override
    public ByteBuffer getVsram() {
        return this.vsram;
    }

    @Override
    public int[] getJavaColorPalette() {
        return this.javaPalette;
    }

    protected void writeVsramByte(int address, byte data) {
        if ((address &= 0x7F) < 80) {
            this.vsram.put(address, data);
        }
    }

    protected void writeCramByte(int address, byte data) {
        this.cram.put(address & 0x7F, data);
        this.paletteUpdate(address & 0x7F & 0xFFFFFFFE);
    }

    protected byte readCramByte(int address) {
        return this.cram.get(address & 0x7F);
    }

    protected byte readVsramByte(int address) {
        if ((address &= 0x7F) >= 80) {
            address = 0;
        }
        return this.vsram.get(address);
    }

    protected int readVramWord(int address) {
        return (this.readVramByte(address &= 0xFFFFFFFE) & 0xFF) << 8 | this.readVramByte(address + 1) & 0xFF;
    }

    protected int readVsramWord(int address) {
        return (this.readVsramByte(address &= 0xFFFFFFFE) & 0xFF) << 8 | this.readVsramByte(address + 1) & 0xFF;
    }

    protected int readCramWord(int address) {
        return (this.readCramByte(address &= 0xFFFFFFFE) & 0xFF) << 8 | this.readCramByte(address + 1) & 0xFF;
    }
}

