/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp.md;

import omegadrive.vdp.model.VdpMisc;

public class VdpColorMapper {
    public static final int VDP_TONES_PER_CHANNEL = 8;
    public static final int OUTPUT_TONES_PER_CHANNEL = 256;
    public static final double VDP_MAX_COLOR_LEVEL = 4.7;
    private static final int[][][] colorsCache = new int[8][8][8];
    private static final int[][][] colorsCacheShadow = new int[8][8][8];
    private static final int[][][] colorsCacheHighLight = new int[8][8][8];
    private static final double[] NORMAL_LEVELS = new double[]{0.0, 0.9, 1.6, 2.2, 2.7, 3.2, 3.8, 4.7};
    private static final double[] SHADOW_LEVELS = new double[]{0.0, 0.5, 0.9, 1.3, 1.6, 1.9, 2.2, 2.4};
    private static final double[] HIGHLIGHT_LEVELS = new double[]{2.4, 2.7, 2.9, 3.2, 3.5, 3.8, 4.2, 4.7};
    private static final VdpColorMapper INSTANCE = new VdpColorMapper();

    private VdpColorMapper() {
        VdpColorMapper.initColorsCache(colorsCache, NORMAL_LEVELS);
        VdpColorMapper.initColorsCache(colorsCacheShadow, SHADOW_LEVELS);
        VdpColorMapper.initColorsCache(colorsCacheHighLight, HIGHLIGHT_LEVELS);
    }

    public static VdpColorMapper getInstance() {
        return INSTANCE;
    }

    private int getColor(int red, int green, int blue, VdpMisc.ShadowHighlightType shadowHighlightType) {
        switch (shadowHighlightType) {
            case NORMAL: {
                return colorsCache[red][green][blue];
            }
            case HIGHLIGHT: {
                return colorsCacheHighLight[red][green][blue];
            }
            case SHADOW: {
                return colorsCacheShadow[red][green][blue];
            }
        }
        return colorsCache[red][green][blue];
    }

    public int getColor(int cramEncodedColor, VdpMisc.ShadowHighlightType shadowHighlightType) {
        return this.getColor(cramEncodedColor >> 1 & 7, cramEncodedColor >> 5 & 7, cramEncodedColor >> 9 & 7, shadowHighlightType);
    }

    public int getColor(int cramEncodedColor) {
        return colorsCache[cramEncodedColor >> 1 & 7][cramEncodedColor >> 5 & 7][cramEncodedColor >> 9 & 7];
    }

    private static void initColorsCache(int[][][] colorsCache, double[] levels) {
        double factor = 54.25531914893617;
        for (int r = 0; r < 8; ++r) {
            for (int g = 0; g < 8; ++g) {
                for (int b = 0; b < 8; ++b) {
                    int color;
                    int red = (int)Math.round(levels[r] * factor);
                    int green = (int)Math.round(levels[g] * factor);
                    int blue = (int)Math.round(levels[b] * factor);
                    colorsCache[r][g][b] = color = red << 16 | green << 8 | blue;
                }
            }
        }
    }
}

