/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp.model;

public enum InterlaceMode {
    NONE,
    MODE_1,
    INVALID,
    MODE_2(1);

    public static final InterlaceMode[] lookup;
    private int tileShift = 5;
    private int verticalScrollShift = 0;
    private int verticalCellPixelSize = 8;
    private int interlaceAdjust = 0;
    private int tileIndexMask = 65535;

    private InterlaceMode() {
    }

    private InterlaceMode(int interlaceAdjust) {
        this.interlaceAdjust = interlaceAdjust;
        this.tileShift += interlaceAdjust;
        this.verticalScrollShift = interlaceAdjust;
        this.verticalCellPixelSize <<= interlaceAdjust;
        this.tileIndexMask = 65535 - interlaceAdjust;
    }

    public static InterlaceMode getInterlaceMode(int index) {
        return lookup[index];
    }

    public int tileShift() {
        return this.tileShift;
    }

    public int interlaceAdjust() {
        return this.interlaceAdjust;
    }

    public int verticalScrollShift() {
        return this.verticalScrollShift;
    }

    public int getVerticalCellPixelSize() {
        return this.verticalCellPixelSize;
    }

    public int getTileIndexMask() {
        return this.tileIndexMask;
    }

    public boolean isInterlaced() {
        return this == MODE_1 || this == MODE_2;
    }

    static {
        lookup = InterlaceMode.values();
    }
}

