/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp.model;

import java.util.EnumMap;
import omegadrive.bus.model.MdMainBusProvider;
import omegadrive.util.LogHelper;
import omegadrive.vdp.md.MdVdp;
import omegadrive.vdp.md.VdpFifo;
import omegadrive.vdp.model.BaseVdpAdapterEventSupport;
import omegadrive.vdp.model.BaseVdpProvider;
import omegadrive.vdp.model.InterlaceMode;
import omegadrive.vdp.model.VdpDmaHandler;
import org.slf4j.Logger;

public interface MdVdpProvider
extends BaseVdpProvider {
    public static final Logger LOG = LogHelper.getLogger(MdVdpProvider.class.getSimpleName());
    public static final int MAX_SPRITES_PER_FRAME_H40 = 80;
    public static final int MAX_SPRITES_PER_FRAME_H32 = 64;
    public static final int MAX_SPRITES_PER_LINE_H40 = 20;
    public static final int MAX_SPRITES_PER_LINE_H32 = 16;
    public static final int VDP_VIDEO_COLS = 320;
    public static final int VDP_CRAM_SIZE = 128;
    public static final int VDP_CRAM_MASK = 127;
    public static final int VDP_VSRAM_SIZE = 80;
    public static final int VDP_VRAM_SIZE = 65536;
    public static final int VDP_VRAM_MASK = 65535;
    public static final int VDP_REGISTERS_SIZE = 24;
    public static final EnumMap<BaseVdpAdapterEventSupport.VdpEvent, VDP_INT> eventMap = new EnumMap(BaseVdpAdapterEventSupport.VdpEvent.class);

    public static MdVdpProvider createVdp(MdMainBusProvider bus) {
        return MdVdp.createInstance(bus);
    }

    public void writeVdpPortWord(VdpPortType var1, int var2);

    public int readVdpPortWord(VdpPortType var1);

    public int getVCounter();

    public int getHCounter();

    public int getAddressRegister();

    public void setAddressRegister(int var1);

    public void setDmaFlag(int var1);

    public boolean getVip();

    public void setVip(boolean var1);

    public boolean getHip();

    public void setHip(boolean var1);

    public boolean isShadowHighlight();

    public VdpFifo getFifo();

    public VramMode getVramMode();

    public InterlaceMode getInterlaceMode();

    public boolean isDisplayEnabled();

    default public int getRegisterData(VdpRegisterName registerName) {
        return this.getRegisterData(registerName.ordinal());
    }

    default public void updateRegisterData(VdpRegisterName registerName, int data) {
        this.updateRegisterData(registerName.ordinal(), data);
    }

    default public void writeControlPort(int data) {
        this.writeVdpPortWord(VdpPortType.CONTROL, data);
    }

    default public void writeDataPort(int data) {
        this.writeVdpPortWord(VdpPortType.DATA, data);
    }

    default public void fifoPush(int addressRegister, int data) {
        this.getFifo().push(this.getVramMode(), addressRegister, data);
    }

    public static enum VdpRegisterName {
        MODE_1,
        MODE_2,
        PLANE_A_NAMETABLE,
        WINDOW_NAMETABLE,
        PLANE_B_NAMETABLE,
        SPRITE_TABLE_LOC,
        SPRITE_PATTERN_BASE_ADDR,
        BACKGROUND_COLOR,
        UNUSED1,
        UNUSED2,
        HCOUNTER_VALUE,
        MODE_3,
        MODE_4,
        HORIZONTAL_SCROLL_DATA_LOC,
        NAMETABLE_PATTERN_BASE_ADDR,
        AUTO_INCREMENT,
        PLANE_SIZE,
        WINDOW_PLANE_HOR_POS,
        WINDOW_PLANE_VERT_POS,
        DMA_LENGTH_LOW,
        DMA_LENGTH_HIGH,
        DMA_SOURCE_LOW,
        DMA_SOURCE_MID,
        DMA_SOURCE_HIGH;

        private static final VdpRegisterName[] lookup;

        public static VdpRegisterName getRegisterName(int index) {
            return lookup[index];
        }

        static {
            lookup = VdpRegisterName.values();
        }
    }

    public static enum VdpPortType {
        DATA,
        CONTROL;

    }

    public static enum VramMode {
        vramRead(0, VdpRamType.VRAM),
        vramWrite(1, VdpRamType.VRAM),
        cramWrite(3, VdpRamType.CRAM),
        vsramRead(4, VdpRamType.VSRAM),
        vsramWrite(5, VdpRamType.VSRAM),
        cramRead(8, VdpRamType.CRAM),
        vramRead_8bit(12, VdpRamType.VRAM);

        private final VdpRamType ramType;
        private final int addressMode;
        private static final VramMode[] lookup;

        private VramMode(int addressMode, VdpRamType ramType) {
            this.ramType = ramType;
            this.addressMode = addressMode;
        }

        public static VramMode getVramMode(int addressMode, boolean verbose) {
            VramMode m = lookup[addressMode];
            if (verbose && m == null) {
                LOG.warn("Unexpected value: {}, vramMode is null", (Object)addressMode);
            }
            return m;
        }

        public static VramMode getVramMode(int addressMode) {
            return VramMode.getVramMode(addressMode, false);
        }

        public int getAddressMode() {
            return this.addressMode;
        }

        public VdpRamType getRamType() {
            return this.ramType;
        }

        public boolean isWriteMode() {
            return this == vramWrite || this == vsramWrite || this == cramWrite;
        }

        static {
            lookup = new VramMode[16];
            VramMode[] vramModeArray = VramMode.values();
            int n = vramModeArray.length;
            for (int i = 0; i < n; ++i) {
                VramMode v;
                VramMode.lookup[v.addressMode] = v = vramModeArray[i];
            }
        }
    }

    public static enum VDP_INT {
        IE0(BaseVdpAdapterEventSupport.VdpEvent.VDP_IE0_VINT),
        IE1(BaseVdpAdapterEventSupport.VdpEvent.VDP_IE1_HINT),
        IE2(BaseVdpAdapterEventSupport.VdpEvent.VDP_IE2_EXT_INT);

        public final BaseVdpAdapterEventSupport.VdpEvent event;

        private VDP_INT(BaseVdpAdapterEventSupport.VdpEvent event) {
            this.event = event;
            eventMap.put(event, this);
        }
    }

    public static enum VdpBusyState {
        MEM_TO_VRAM,
        VRAM_FILL,
        VRAM_COPY,
        FIFO_FULL,
        NOT_BUSY;

        private static final VdpBusyState[] values;

        public static VdpBusyState getVdpBusyState(VdpDmaHandler.DmaMode mode) {
            if (mode == null) {
                return NOT_BUSY;
            }
            return values[mode.ordinal()];
        }

        static {
            values = VdpBusyState.values();
        }
    }

    public static enum VdpRamType {
        VRAM,
        CRAM,
        VSRAM;

    }
}

