/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp.model;

import java.util.Arrays;
import java.util.stream.IntStream;

public enum VdpSlotType {
    NONE,
    REFRESH,
    EXTERNAL;

    public static final VdpSlotType[] h32Slots;
    public static final VdpSlotType[] h40Slots;
    private static final int[] refreshSlotsH32;
    private static final int[] refreshSlotsH40;
    private static final int[] externalSlotsH32;
    private static final int[] externalSlotsH40;

    static {
        h32Slots = new VdpSlotType[171];
        h40Slots = new VdpSlotType[210];
        refreshSlotsH32 = new int[]{38, 70, 102, 134};
        refreshSlotsH40 = new int[]{38, 70, 102, 134, 166};
        externalSlotsH32 = new int[]{14, 22, 30, 46, 54, 62, 78, 86, 94, 110, 118, 126, 141, 142, 156, 170};
        externalSlotsH40 = new int[]{14, 22, 30, 46, 54, 62, 78, 86, 94, 110, 118, 126, 142, 150, 158, 173, 174, 198};
        Arrays.fill((Object[])h32Slots, (Object)NONE);
        Arrays.fill((Object[])h40Slots, (Object)NONE);
        IntStream.of(externalSlotsH32).forEach(i -> {
            VdpSlotType.h32Slots[i] = EXTERNAL;
        });
        IntStream.of(externalSlotsH40).forEach(i -> {
            VdpSlotType.h40Slots[i] = EXTERNAL;
        });
        IntStream.of(refreshSlotsH32).forEach(i -> {
            VdpSlotType.h32Slots[i] = REFRESH;
        });
        IntStream.of(refreshSlotsH40).forEach(i -> {
            VdpSlotType.h40Slots[i] = REFRESH;
        });
    }
}

