/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp.util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import omegadrive.vdp.md.VdpInterruptHandler;
import omegadrive.vdp.model.MdVdpProvider;

public class VdpPortAccessLogger {
    public static final VdpPortAccessLogger NO_LOGGER = new VdpPortAccessLogger(null);
    private final VdpInterruptHandler handler;
    private final List<VdpWriteContext> writes;

    public VdpPortAccessLogger(VdpInterruptHandler handler) {
        this.handler = handler;
        this.writes = new ArrayList<VdpWriteContext>();
    }

    public void logVdpWrite(MdVdpProvider.VdpPortType type, int value) {
        VdpWriteContext v = new VdpWriteContext();
        v.hcInternal = this.handler.gethCounterInternal();
        v.hcExternal = this.handler.getHCounterExternal();
        v.vcInternal = this.handler.getvCounterInternal();
        v.vcExternal = this.handler.getVCounterExternal();
        v.value = value;
        v.portType = type;
        this.writes.add(v);
    }

    public String getWritesAsString() {
        return this.writes.stream().map(VdpWriteContext::toShortString).collect(Collectors.joining("\n"));
    }

    public List<VdpWriteContext> getWrites() {
        return this.writes;
    }

    public void reset() {
        this.writes.clear();
    }

    public static class VdpWriteContext {
        public int hcInternal;
        public int vcInternal;
        public int hcExternal;
        public int vcExternal;
        public int value;
        public MdVdpProvider.VdpPortType portType;

        public static VdpWriteContext parseShortString(String s) {
            String[] tk = s.split(",");
            VdpWriteContext v = new VdpWriteContext();
            v.hcExternal = Integer.parseInt(tk[0]);
            v.vcExternal = Integer.parseInt(tk[1]);
            v.hcInternal = Integer.parseInt(tk[2]);
            v.vcInternal = Integer.parseInt(tk[3]);
            v.portType = MdVdpProvider.VdpPortType.valueOf(tk[4]);
            v.value = Integer.parseInt(tk[5]);
            return v;
        }

        public String toShortString() {
            return this.hcExternal + "," + this.vcExternal + "," + this.hcInternal + "," + this.vcInternal + "," + String.valueOf((Object)this.portType) + "," + this.value;
        }
    }
}

