/*
 * Decompiled with CFR 0.152.
 */
package s32x;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Optional;
import mcd.McdDeviceHelper;
import mcd.MegaCd;
import mcd.bus.Mcd32xMainBus;
import mcd.bus.McdSubInterruptHandler;
import omegadrive.SystemLoader;
import omegadrive.bus.model.MdMainBusProvider;
import omegadrive.cart.MdCartInfoProvider;
import omegadrive.cpu.m68k.M68kProvider;
import omegadrive.system.MediaSpecHolder;
import omegadrive.system.SysUtil;
import omegadrive.system.SystemProvider;
import omegadrive.ui.DisplayWindow;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.MdRuntimeData;
import omegadrive.util.Util;
import omegadrive.util.VideoMode;
import org.slf4j.Logger;
import s32x.Md32x;
import s32x.StaticBootstrapSupport;
import s32x.bus.S32xBusIntf;

public class MegaCd32x
extends Md32x {
    private static final Logger LOG = LogHelper.getLogger(MegaCd32x.class.getSimpleName());
    protected double nextSub68kCycle = 1.0;
    protected M68kProvider subCpu;
    protected McdSubInterruptHandler interruptHandler;
    protected McdDeviceHelper.McdLaunchContext mcdLaunchContext;
    private double mcd68kRatio;
    protected S32xBusIntf s32xBus;
    double subCnt = 0.0;

    public MegaCd32x(DisplayWindow emuFrame) {
        super(emuFrame);
        this.systemType = SystemLoader.SystemType.MEGACD_S32X;
        LogHelper.logWarnOnce(LOG, "TowerOfPower", new Object[0]);
    }

    @Override
    public void init() {
        this.mcdLaunchContext = McdDeviceHelper.setupDevices();
        super.init();
        this.vdp.addVdpEventListener(this.mcdLaunchContext.subBus);
        ((MdMainBusProvider)this.bus).attachDevices(this, this.memory, this.joypad, this.vdp, this.cpu, this.z80, this.sound);
        this.mcdLaunchContext.subBus.attachDevice(this);
        this.subCpu = this.mcdLaunchContext.subCpu;
        this.interruptHandler = this.mcdLaunchContext.interruptHandler;
        MegaCd.megaCdDiscInsert(this.mcdLaunchContext, this.mediaSpec);
        this.checkDoomFusion();
        this.subCpu.reset();
    }

    @Override
    protected S32xBusIntf getS32xBus() {
        assert (this.s32xBus != null);
        return this.s32xBus;
    }

    public static SystemProvider createNewInstance(DisplayWindow emuFrame) {
        return new MegaCd32x(emuFrame);
    }

    @Override
    protected void loop() {
        this.updateVideoMode(true);
        assert (this.cycleCounter == 1);
        do {
            this.run68k();
            this.runSub68k();
            this.runZ80();
            this.runFM();
            this.runSh2();
            this.runDevices();
            this.runVdp();
            ++this.cycleCounter;
        } while (!this.futureDoneFlag);
    }

    protected void runSub68k() {
        while (this.nextSub68kCycle <= (double)this.cycleCounter) {
            boolean canRun = !this.subCpu.isStopped();
            int cycleDelayCpu = 1;
            MdRuntimeData.setAccessTypeExt(BufferUtil.CpuDeviceAccess.SUB_M68K);
            if (canRun) {
                cycleDelayCpu = this.subCpu.runInstruction() + MdRuntimeData.resetCpuDelayExt();
            }
            this.interruptHandler.handleInterrupts();
            cycleDelayCpu = Math.max(1, cycleDelayCpu);
            this.subCnt += (double)cycleDelayCpu;
            this.mcdLaunchContext.stepDevices(cycleDelayCpu);
            this.nextSub68kCycle += 1.0 * this.mcd68kRatio * (double)cycleDelayCpu;
            assert (MdRuntimeData.resetCpuDelayExt() == 0);
        }
    }

    @Override
    protected void updateVideoMode(boolean force) {
        VideoMode prev = this.displayContext.videoMode;
        super.updateVideoMode(force);
        if (force || prev != this.vdp.getVideoMode()) {
            assert (this.displayContext.videoMode == this.vdp.getVideoMode());
            this.mcd68kRatio = this.displayContext.videoMode.isPal() ? 0.6080391314285715 : 0.6136362857142857;
            this.mcdLaunchContext.pcm.updateVideoMode(this.displayContext.videoMode);
            this.mcdLaunchContext.cdd.updateVideoMode(this.displayContext.videoMode);
            this.mcdLaunchContext.interruptHandler.setRegion(this.displayContext.videoMode.getRegion());
            LOG.info("Video mode changed: {}, mcd68kRatio: {}", (Object)this.displayContext.videoMode, (Object)this.mcd68kRatio);
        }
    }

    @Override
    protected MdMainBusProvider createBus() {
        Mcd32xMainBus b = new Mcd32xMainBus(this.mcdLaunchContext);
        this.s32xBus = b.s32xBus;
        return b;
    }

    @Override
    public void newFrame() {
        this.mcdLaunchContext.pcm.newFrame();
        this.mcdLaunchContext.cdd.newFrame();
        this.displayContext.megaCdLedState = Optional.of(this.mcdLaunchContext.subBus.getLedState());
        super.newFrame();
    }

    @Override
    protected void doRendering(int[] data) {
        super.doRendering(data);
        this.displayContext.videoMode = this.vdp.getVideoMode();
    }

    @Override
    protected void resetCycleCounters(int counter) {
        super.resetCycleCounters(counter);
        assert (this.nextSub68kCycle >= (double)counter);
        this.nextSub68kCycle = Math.max(1.0, this.nextSub68kCycle - (double)counter);
    }

    @Override
    protected void handleCloseRom() {
        super.handleCloseRom();
        this.mcdLaunchContext.cdd.close();
        this.mcdLaunchContext.pcm.close();
    }

    @Override
    public void handleNewRom(MediaSpecHolder romSpec) {
        super.handleNewRom(romSpec);
        StaticBootstrapSupport.initStatic(this);
    }

    @Override
    protected void handleSoftReset() {
        if (this.softResetPending) {
            this.subCpu.softReset();
        }
        super.handleSoftReset();
    }

    @Override
    protected void init32x() {
        super.init32x();
    }

    private void checkDoomFusion() {
        MdCartInfoProvider cartInfo = (MdCartInfoProvider)this.mediaSpec.getBootableMedia().mediaInfoProvider;
        String serial = cartInfo.getSerial();
        String name = cartInfo.getRomName();
        if (name.startsWith("DCD32X") || serial.contains("DMF32XCD")) {
            String isoName = Util.getNameWithoutExtension(name) + ".iso";
            MediaSpecHolder.MediaSpec iso = MediaSpecHolder.MediaSpec.of(this.mediaSpec.getBootableMedia().romFile.resolveSibling(isoName), SysUtil.RomFileType.ISO, this.mediaSpec.systemType);
            assert (Files.exists(iso.romFile, new LinkOption[0]));
            LOG.warn("DoomCD32x Fusion detected attempting to load iso file: {}", (Object)iso.romFile.toAbsolutePath());
            this.mediaSpec.cdFile = iso;
            iso.systemType = this.mediaSpec.cartFile.systemType = SystemLoader.SystemType.MEGACD_S32X;
            this.mediaSpec.systemType = this.mediaSpec.cartFile.systemType;
            this.mediaSpec.reload();
            MegaCd.megaCdDiscInsert(this.mcdLaunchContext, this.mediaSpec);
        } else {
            assert (this.mediaSpec.hasDiscImage());
            this.mediaSpec.systemType = this.mediaSpec.cdFile.systemType = SystemLoader.SystemType.MEGACD_S32X;
        }
    }
}

