/*
 * Decompiled with CFR 0.152.
 */
package s32x;

import java.io.Serializable;
import java.nio.ByteBuffer;
import omegadrive.Device;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.MdRuntimeData;
import omegadrive.util.Size;
import omegadrive.util.Util;
import omegadrive.util.VideoMode;
import org.slf4j.Logger;
import s32x.DmaFifo68k;
import s32x.dict.S32xDict;
import s32x.dict.S32xMemAccessDelay;
import s32x.event.PollSysEventManager;
import s32x.pwm.Pwm;
import s32x.savestate.Gs32xStateHandler;
import s32x.sh2.device.IntControl;
import s32x.sh2.prefetch.Sh2Prefetch;
import s32x.vdp.MarsVdp;
import s32x.vdp.MarsVdpImpl;

public class S32XMMREG
implements Device {
    private static final Logger LOG = LogHelper.getLogger(S32XMMREG.class.getSimpleName());
    private static final boolean verbose = false;
    private static final boolean verboseRead = false;
    public static final int CART_INSERTED = 0;
    public static final int CART_NOT_INSERTED = 1;
    public int fm = 0;
    public int aden = 0;
    private S32XMMREGContext ctx = new S32XMMREGContext();
    public final RegContext regContext = new RegContext();
    private final ByteBuffer sysRegsSh2;
    private final ByteBuffer sysRegsMd;
    public IntControl[] interruptControls;
    public Pwm pwm;
    public DmaFifo68k dmaFifoControl;
    private MarsVdp vdp;
    private S32xDict.S32xDictLogContext logCtx;
    private MarsVdp.MarsVdpContext vdpContext;
    private int deviceAccessType;

    public S32XMMREG() {
        this.sysRegsSh2 = this.regContext.sysRegsSh2;
        this.sysRegsMd = this.regContext.sysRegsMd;
        this.init();
    }

    @Override
    public void init() {
        this.vdpContext = new MarsVdp.MarsVdpContext();
        BufferUtil.writeBufferRaw(this.regContext.sysRegsMd, S32xDict.RegSpecS32x.MD_ADAPTER_CTRL.addr, 130, Size.WORD);
        this.vdp = MarsVdpImpl.createInstance(this.vdpContext, this);
        this.logCtx = new S32xDict.S32xDictLogContext();
        S32xDict.z80RegAccess.clear();
        Gs32xStateHandler.addDevice(this);
    }

    public MarsVdp getVdp() {
        return this.vdp;
    }

    public void setHBlank(boolean hBlankOn) {
        this.vdp.setHBlank(hBlankOn, this.ctx.hen);
    }

    public void setVBlank(boolean vBlankOn) {
        this.vdp.setVBlank(vBlankOn);
    }

    public void write(int address, int value, Size size) {
        if ((address &= 0xFFFFFFF) >= 16384 && address < 16896) {
            this.handleRegWrite(address, value, size);
            S32xMemAccessDelay.addWriteCpuDelay(this.deviceAccessType);
        } else {
            this.vdp.write(address, value, size);
        }
    }

    public int read(int address, Size size) {
        int res = 0;
        if ((address &= 0xFFFFFFF) >= 16384 && address < 16896) {
            res = this.handleRegRead(address, size);
            S32xMemAccessDelay.addReadCpuDelay(this.deviceAccessType);
        } else {
            res = this.vdp.read(address, size);
        }
        return res;
    }

    private int handleRegRead(int address, Size size) {
        BufferUtil.CpuDeviceAccess cpu = MdRuntimeData.getAccessTypeExt();
        S32xDict.RegSpecS32x regSpec = S32xDict.getRegSpec(cpu, address);
        if (regSpec == S32xDict.RegSpecS32x.INVALID) {
            LOG.error("{} unable to handle read, addr: {} {}", new Object[]{cpu, Util.th(address), size});
            return size.getMask();
        }
        this.deviceAccessType = regSpec.deviceAccessTypeDelay;
        int res = 0;
        switch (regSpec.deviceType) {
            case DMA: {
                assert (regSpec == S32xDict.RegSpecS32x.MD_DMAC_CTRL || cpu != BufferUtil.CpuDeviceAccess.Z80) : regSpec;
                res = this.dmaFifoControl.read(regSpec, cpu, address & 0x1FF, size);
                break;
            }
            case PWM: {
                res = this.pwm.read(cpu, regSpec, address & 0xFF, size);
                break;
            }
            case COMM: {
                res = BufferUtil.readBufferReg(this.regContext, regSpec, address, size);
                break;
            }
            default: {
                assert (regSpec.addr < S32xDict.RegSpecS32x.MD_DREQ_SRC_ADDR_H.addr || cpu != BufferUtil.CpuDeviceAccess.Z80) : regSpec;
                res = BufferUtil.readBufferReg(this.regContext, regSpec, address, size);
                if (regSpec != S32xDict.RegSpecS32x.SH2_INT_MASK) break;
                res = this.interruptControls[cpu.ordinal()].readSh2IntMaskReg(address & 0x1FF, size);
            }
        }
        return res;
    }

    private boolean handleRegWrite(int address, int value, Size size) {
        int reg = address & 0xFF;
        BufferUtil.CpuDeviceAccess cpu = MdRuntimeData.getAccessTypeExt();
        S32xDict.RegSpecS32x regSpec = S32xDict.getRegSpec(cpu, address);
        boolean regChanged = false;
        assert (this.checkWriteLongAccess(regSpec, reg, size));
        this.deviceAccessType = regSpec.deviceAccessTypeDelay;
        switch (regSpec.deviceType) {
            case VDP: {
                assert (cpu != BufferUtil.CpuDeviceAccess.Z80) : regSpec;
                regChanged = this.vdp.vdpRegWrite(regSpec, reg, value, size);
                break;
            }
            case PWM: {
                this.pwm.write(cpu, regSpec, reg, value, size);
                break;
            }
            case COMM: {
                regChanged = this.handleCommRegWrite(regSpec, reg, value, size);
                break;
            }
            case SYS: {
                assert (regSpec.addr < S32xDict.RegSpecS32x.MD_DREQ_SRC_ADDR_H.addr || cpu != BufferUtil.CpuDeviceAccess.Z80) : regSpec;
                regChanged = this.handleSysRegWrite(cpu, regSpec, reg, value, size);
                break;
            }
            case DMA: {
                assert (regSpec == S32xDict.RegSpecS32x.MD_DMAC_CTRL || cpu != BufferUtil.CpuDeviceAccess.Z80) : regSpec;
                this.dmaFifoControl.write(regSpec, cpu, reg, value, size);
                break;
            }
            default: {
                LogHelper.logWarnOnce(LOG, "{} unexpected reg write, addr: {}, {} {}", new Object[]{cpu, Util.th(address), Util.th(value), size});
                regChanged = true;
            }
        }
        if (regChanged) {
            Sh2Prefetch.checkPoller(cpu, regSpec.deviceType, address, value, size);
        }
        return regChanged;
    }

    private boolean handleSysRegWrite(BufferUtil.CpuDeviceAccess cpu, S32xDict.RegSpecS32x regSpec, int reg, int value, Size size) {
        assert (size != Size.LONG);
        boolean regChanged = false;
        switch (regSpec) {
            case SH2_INT_MASK: 
            case MD_ADAPTER_CTRL: {
                regChanged = this.handleReg0Write(cpu, reg, value, size);
                break;
            }
            case SH2_STBY_CHANGE: 
            case MD_INT_CTRL: {
                regChanged = this.handleReg2Write(cpu, reg, value, size);
                break;
            }
            case SH2_HCOUNT_REG: 
            case MD_BANK_SET: {
                regChanged = this.handleReg4Write(cpu, reg, value, size);
                break;
            }
            case SH2_VINT_CLEAR: 
            case SH2_HINT_CLEAR: 
            case SH2_PWM_INT_CLEAR: 
            case SH2_CMD_INT_CLEAR: 
            case SH2_VRES_INT_CLEAR: {
                this.handleIntClearWrite(cpu, regSpec, reg, value, size);
                regChanged = true;
                break;
            }
            case MD_SEGA_TV: {
                LOG.warn("{} {} unexpected write, addr: {}, {} {}", new Object[]{cpu, regSpec, Util.th(reg), Util.th(value), size});
                BufferUtil.writeBufferReg(this.regContext, regSpec, reg, value, size);
                break;
            }
            default: {
                LOG.error("{} sysReg unexpected write, addr: {}, {} {}", new Object[]{cpu, Util.th(reg), Util.th(value), size});
                BufferUtil.writeBufferReg(this.regContext, regSpec, reg, value, size);
            }
        }
        return regChanged;
    }

    private boolean handleCommRegWrite(S32xDict.RegSpecS32x regSpec, int reg, int value, Size size) {
        boolean regChanged;
        int currentVal = BufferUtil.readBufferReg(this.regContext, regSpec, reg, size);
        boolean bl = regChanged = currentVal != value;
        if (regChanged) {
            BufferUtil.writeBuffers(this.sysRegsMd, this.sysRegsSh2, reg, value, size);
            MdRuntimeData.addCpuDelayExt(12);
        }
        return regChanged;
    }

    private void doLog(BufferUtil.CpuDeviceAccess cpu, S32xDict.RegSpecS32x regSpec, int address, int value, Size size, boolean read) {
        boolean isSys;
        boolean bl = isSys = address < 16640;
        ByteBuffer regArea = isSys ? (cpu == BufferUtil.CpuDeviceAccess.M68K ? this.sysRegsMd : this.sysRegsSh2) : this.regContext.vdpRegs;
        this.logCtx.cpu = MdRuntimeData.getAccessTypeExt();
        this.logCtx.regSpec = regSpec;
        this.logCtx.regArea = regArea;
        this.logCtx.read = read;
        this.logCtx.fbD = this.vdpContext.frameBufferDisplay;
        this.logCtx.fbW = this.vdpContext.frameBufferWritable;
        S32xDict.checkName(this.logCtx.cpu, regSpec, address, size);
        S32xDict.logAccess(this.logCtx, address, value, size);
        S32xDict.detectRegAccess(this.logCtx, address, value, size);
        S32xDict.logZ80Access(cpu, regSpec, address, size, read);
    }

    private void handleIntClearWrite(BufferUtil.CpuDeviceAccess cpu, S32xDict.RegSpecS32x regSpec, int reg, int value, Size size) {
        int newVal;
        boolean change;
        assert (cpu == BufferUtil.CpuDeviceAccess.MASTER || cpu == BufferUtil.CpuDeviceAccess.SLAVE);
        int intIdx = IntControl.Sh2Interrupt.VRES_14.level - ((reg & 0xFFFFFFFE) - 20);
        IntControl.Sh2Interrupt intType = IntControl.intVals[intIdx];
        this.interruptControls[cpu.ordinal()].clearExternalInterrupt(intType);
        if (intType != IntControl.Sh2Interrupt.CMD_08 || (change = this.handleIntControlWriteMd(S32xDict.RegSpecS32x.MD_INT_CTRL.addr, newVal = Util.setBit(this.readWordFromBuffer(S32xDict.RegSpecS32x.MD_INT_CTRL), cpu.ordinal(), 0), Size.WORD))) {
            // empty if block
        }
        regSpec.regSpec.write(this.sysRegsSh2, reg, value, size);
    }

    private boolean handleReg4Write(BufferUtil.CpuDeviceAccess cpu, int reg, int value, Size size) {
        return switch (cpu.regSide) {
            default -> throw new IncompatibleClassChangeError();
            case BufferUtil.S32xRegSide.MD -> S32xDict.RegSpecS32x.MD_BANK_SET.regSpec.write(this.sysRegsMd, reg, value, size);
            case BufferUtil.S32xRegSide.SH2 -> S32xDict.RegSpecS32x.SH2_HCOUNT_REG.regSpec.write(this.sysRegsSh2, reg, value, size);
        };
    }

    private boolean handleReg2Write(BufferUtil.CpuDeviceAccess cpu, int reg, int value, Size size) {
        boolean res = switch (cpu.regSide) {
            default -> throw new IncompatibleClassChangeError();
            case BufferUtil.S32xRegSide.MD -> this.handleIntControlWriteMd(reg, value, size);
            case BufferUtil.S32xRegSide.SH2 -> BufferUtil.writeBufferRaw(this.sysRegsSh2, reg, value, size);
        };
        return res;
    }

    private boolean handleIntControlWriteMd(int reg, int value, Size size) {
        boolean changed = S32xDict.RegSpecS32x.MD_INT_CTRL.regSpec.write(this.sysRegsMd, reg, value, size);
        if (changed) {
            int newVal = Util.readBufferWord(this.sysRegsMd, S32xDict.RegSpecS32x.MD_INT_CTRL.addr);
            boolean intm = (newVal & 1) > 0;
            boolean ints = (newVal & 2) > 0;
            this.interruptControls[0].setIntPending(IntControl.Sh2Interrupt.CMD_08, intm);
            this.interruptControls[1].setIntPending(IntControl.Sh2Interrupt.CMD_08, ints);
        }
        return changed;
    }

    private boolean handleReg0Write(BufferUtil.CpuDeviceAccess cpu, int reg, int value, Size size) {
        boolean res = switch (cpu.regSide) {
            default -> throw new IncompatibleClassChangeError();
            case BufferUtil.S32xRegSide.MD -> this.handleAdapterControlRegWriteMd(reg, value, size);
            case BufferUtil.S32xRegSide.SH2 -> this.handleIntMaskRegWriteSh2(cpu, reg, value, size);
        };
        return res;
    }

    private boolean handleAdapterControlRegWriteMd(int reg, int value, Size size) {
        assert (size != Size.LONG);
        int prev = this.readWordFromBuffer(S32xDict.RegSpecS32x.MD_ADAPTER_CTRL);
        boolean changed = S32xDict.RegSpecS32x.MD_ADAPTER_CTRL.regSpec.write(this.regContext.sysRegsMd, reg, value, size);
        if (changed) {
            int newVal = this.readWordFromBuffer(S32xDict.RegSpecS32x.MD_ADAPTER_CTRL);
            newVal = this.handleAden(newVal);
            this.handleReset(prev, newVal);
            this.updateFmShared(newVal);
        }
        return changed;
    }

    private int handleAden(int newVal) {
        if (this.aden > 0 && (newVal & 1) == 0) {
            LOG.warn("{} Disabling ADEN not allowed", (Object)MdRuntimeData.getAccessTypeExt());
            BufferUtil.setBitRegFromWord(this.sysRegsMd, S32xDict.RegSpecS32x.MD_ADAPTER_CTRL, 0, 1);
            newVal |= 1;
        }
        this.setAdenSh2Reg(newVal & 1);
        return newVal;
    }

    private void handleReset(int val, int newVal) {
        if ((val & 2) == 0 && (newVal & 2) > 0) {
            LOG.info("{} unset reset Sh2s (nRes = 0)", (Object)MdRuntimeData.getAccessTypeExt());
            PollSysEventManager.instance.fireSysEvent(BufferUtil.CpuDeviceAccess.MASTER, PollSysEventManager.SysEvent.SH2_RESET_OFF);
        }
        if ((val & 2) > 0 && (newVal & 2) == 0) {
            LOG.info("{} set reset SH2s (nRes = 1)", (Object)MdRuntimeData.getAccessTypeExt());
            PollSysEventManager.instance.fireSysEvent(BufferUtil.CpuDeviceAccess.MASTER, PollSysEventManager.SysEvent.SH2_RESET_ON);
        }
    }

    private void updateFmShared(int wordVal) {
        if (this.fm != (wordVal >> 15 & 1)) {
            this.setFmSh2Reg(wordVal >> 15 & 1);
        }
    }

    private void updateHenShared(int newVal) {
        int nhen = newVal >> 7 & 1;
        if (nhen != this.ctx.hen) {
            this.ctx.hen = nhen;
        }
        BufferUtil.setBit(this.interruptControls[0].getSh2_int_mask_regs(), this.interruptControls[1].getSh2_int_mask_regs(), 1, 7, this.ctx.hen, Size.BYTE);
    }

    private boolean handleIntMaskRegWriteSh2(BufferUtil.CpuDeviceAccess cpu, int reg, int value, Size size) {
        assert (size != Size.LONG);
        int baseReg = reg & 0xFFFFFFFE;
        IntControl ic = this.interruptControls[cpu.ordinal()];
        int prevW = ic.readSh2IntMaskReg(baseReg, Size.WORD);
        BufferUtil.writeBufferRaw(ic.getSh2_int_mask_regs(), reg, value, size);
        int newVal = ic.readSh2IntMaskReg(baseReg, Size.WORD) & 0x808F | (this.ctx.cart << 8 | this.aden << 9);
        assert ((newVal & 0x7C70) == 0);
        BufferUtil.writeBufferRaw(ic.getSh2_int_mask_regs(), baseReg, newVal, Size.WORD);
        ic.reloadSh2IntMask();
        this.updateFmShared(newVal);
        this.updateHenShared(newVal);
        return newVal != prevW;
    }

    public void setCart(int cartSize) {
        this.ctx.cart = cartSize > 0 ? 0 : 1;
        BufferUtil.setBit(this.interruptControls[0].getSh2_int_mask_regs(), this.interruptControls[1].getSh2_int_mask_regs(), 0, 0, this.ctx.cart, Size.BYTE);
        LOG.info("Cart set to {}inserted: {}", (Object)(this.ctx.cart > 0 ? "not " : ""), (Object)this.ctx.cart);
    }

    private void setAdenSh2Reg(int aden) {
        this.aden = aden;
        BufferUtil.setBit(this.interruptControls[0].getSh2_int_mask_regs(), this.interruptControls[1].getSh2_int_mask_regs(), 0, 1, aden, Size.BYTE);
    }

    private void setFmSh2Reg(int fm) {
        this.fm = fm;
        BufferUtil.setBit(this.interruptControls[0].getSh2_int_mask_regs(), this.interruptControls[1].getSh2_int_mask_regs(), 0, 7, fm, Size.BYTE);
        BufferUtil.setBit(this.sysRegsMd, S32xDict.RegSpecS32x.MD_ADAPTER_CTRL.addr, 7, fm, Size.BYTE);
    }

    public void setDmaControl(DmaFifo68k dmaFifoControl) {
        this.dmaFifoControl = dmaFifoControl;
    }

    public void setInterruptControl(IntControl ... interruptControls) {
        this.interruptControls = interruptControls;
    }

    public void setPwm(Pwm pwm) {
        this.pwm = pwm;
    }

    private int readWordFromBuffer(S32xDict.RegSpecS32x reg) {
        return BufferUtil.readWordFromBuffer(this.regContext, reg);
    }

    private boolean checkWriteLongAccess(S32xDict.RegSpecS32x regSpec, int reg, Size size) {
        if (regSpec.deviceType != S32xDict.S32xRegType.COMM && regSpec.deviceType != S32xDict.S32xRegType.VDP && regSpec.deviceType != S32xDict.S32xRegType.PWM && size == Size.LONG) {
            LOG.error("unsupported 32 bit access, reg: {} {}", (Object)regSpec.getName(), (Object)Util.th(reg));
            return reg == 44;
        }
        return true;
    }

    public void updateVideoMode(VideoMode value) {
        this.vdp.updateVideoMode(value);
    }

    @Override
    public void saveContext(ByteBuffer buffer) {
        Device.super.saveContext(buffer);
        this.regContext.sysRegsSh2.rewind().get(this.ctx.sysRegsSh2).rewind();
        this.regContext.sysRegsMd.rewind().get(this.ctx.sysRegsMd).rewind();
        this.regContext.vdpRegs.rewind().get(this.ctx.vdpRegs).rewind();
        this.ctx.fm = this.fm;
        this.ctx.aden = this.aden;
        buffer.put(Util.serializeObject(this.ctx));
    }

    @Override
    public void loadContext(ByteBuffer buffer) {
        Device.super.loadContext(buffer);
        Serializable s = Util.deserializeObject(buffer);
        assert (s instanceof S32XMMREGContext);
        this.ctx = (S32XMMREGContext)s;
        this.regContext.sysRegsMd.rewind().put(this.ctx.sysRegsMd).rewind();
        this.regContext.sysRegsSh2.rewind().put(this.ctx.sysRegsSh2).rewind();
        this.regContext.vdpRegs.rewind().put(this.ctx.vdpRegs).rewind();
        this.fm = this.ctx.fm;
        this.aden = this.ctx.aden;
    }

    private static class S32XMMREGContext
    implements Serializable {
        private static final long serialVersionUID = 8103806630860480125L;
        private int cart = 1;
        public int fm = 0;
        public int aden = 0;
        private int hen = 0;
        private final byte[] sysRegsSh2 = new byte[256];
        private final byte[] sysRegsMd = new byte[256];
        private final byte[] vdpRegs = new byte[256];

        private S32XMMREGContext() {
        }
    }

    public static class RegContext {
        public final ByteBuffer sysRegsSh2 = ByteBuffer.allocate(256);
        public final ByteBuffer sysRegsMd = ByteBuffer.allocate(256);
        public final ByteBuffer vdpRegs = ByteBuffer.allocate(256);
    }
}

