/*
 * Decompiled with CFR 0.152.
 */
package s32x.bus;

import java.io.Serializable;
import java.nio.ByteBuffer;
import omegadrive.Device;
import omegadrive.bus.DeviceAwareBus;
import omegadrive.bus.md.MdBus;
import omegadrive.bus.model.MdMainBusProvider;
import omegadrive.cart.MdCartInfoProvider;
import omegadrive.joypad.MdJoypad;
import omegadrive.sound.PwmProvider;
import omegadrive.sound.fm.FmProvider;
import omegadrive.sound.psg.PsgProvider;
import omegadrive.system.SystemProvider;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.MdRuntimeData;
import omegadrive.util.Size;
import omegadrive.util.Util;
import omegadrive.util.VideoMode;
import omegadrive.vdp.model.BaseVdpAdapterEventSupport;
import omegadrive.vdp.model.MdVdpProvider;
import org.slf4j.Logger;
import s32x.DmaFifo68k;
import s32x.S32XMMREG;
import s32x.bus.S32xBusIntf;
import s32x.dict.S32xDict;
import s32x.savestate.Gs32xStateHandler;
import s32x.sh2.Sh2;
import s32x.sh2.Sh2Context;
import s32x.util.BiosHolder;
import s32x.vdp.MarsVdp;

public class S32xBus
extends DeviceAwareBus<MdVdpProvider, MdJoypad>
implements S32xBusIntf {
    private static final Logger LOG = LogHelper.getLogger(S32xBus.class.getSimpleName());
    static final boolean verboseMd = false;
    private BiosHolder.BiosData bios68k;
    private S32XMMREG s32XMMREG;
    public Sh2Context masterCtx;
    public Sh2Context slaveCtx;
    private Sh2 sh2;
    private S32xBusContext busContext = new S32xBusContext();
    private int bankSetShift;
    protected MdMainBusProvider mdBus;

    public static S32xBusIntf createS32xBus(MdMainBusProvider mdBus) {
        return new S32xBus(mdBus);
    }

    public static S32xBusIntf createS32xBus() {
        return new S32xBus(new MdBus());
    }

    private S32xBus(MdMainBusProvider mdBus) {
        this.bankSetShift = this.busContext.bankSetValue << 20;
        Util.writeData(this.busContext.writeableHint, 0, -1, Size.LONG);
        this.mdBus = mdBus;
        Gs32xStateHandler.addDevice(this);
    }

    @Override
    public void init() {
        super.init();
        this.mdBus.init();
    }

    @Override
    public MdMainBusProvider attachDevice(Device device) {
        super.attachDevice(device);
        if (device instanceof Sh2) {
            this.sh2 = (Sh2)device;
        } else if (device instanceof S32XMMREG) {
            this.s32XMMREG = (S32XMMREG)device;
        } else if (this.vdpProvider != null) {
            ((MdVdpProvider)this.vdpProvider).addVdpEventListener(this);
        }
        this.mdBus.attachDevice(device);
        return this;
    }

    @Override
    public void setRom(ByteBuffer b) {
        this.s32XMMREG.setCart(b.capacity());
    }

    @Override
    public void setSh2Context(Sh2Context master, Sh2Context slave) {
        this.masterCtx = master;
        this.slaveCtx = slave;
    }

    @Override
    public int getBankSetValue() {
        return this.busContext.bankSetValue;
    }

    @Override
    public int read(int address, Size size) {
        int res = 0;
        res = this.s32XMMREG.aden > 0 ? this.readAdapterEnOn(address & 0xFFFFFF, size) : this.readAdapterEnOff(address & 0xFFFFFF, size);
        return res & size.getMask();
    }

    @Override
    public void write(int address, int data, Size size) {
        data &= size.getMask();
        address &= 0xFFFFFF;
        if (this.s32XMMREG.aden > 0) {
            this.writeAdapterEnOn(address, data, size);
        } else {
            this.writeAdapterEnOff(address, data, size);
        }
    }

    @Override
    public void writeIoPort(int port, int value) {
        this.mdBus.writeIoPort(port, value);
    }

    @Override
    public MdCartInfoProvider getCartridgeInfoProvider() {
        return this.mdBus.getCartridgeInfoProvider();
    }

    @Override
    public void handleVdpInterrupts68k() {
        this.mdBus.handleVdpInterrupts68k();
    }

    @Override
    public void handleVdpInterruptsZ80() {
        this.mdBus.handleVdpInterruptsZ80();
    }

    @Override
    public void ackInterrupt68k(int level) {
        this.mdBus.ackInterrupt68k(level);
    }

    @Override
    public void resetFrom68k() {
        this.mdBus.resetFrom68k();
    }

    @Override
    public boolean is68kRunning() {
        return this.mdBus.is68kRunning();
    }

    @Override
    public void setVdpBusyState(MdVdpProvider.VdpBusyState state) {
        this.mdBus.setVdpBusyState(state);
    }

    @Override
    public boolean isZ80Running() {
        return this.mdBus.isZ80Running();
    }

    @Override
    public boolean isZ80ResetState() {
        return this.mdBus.isZ80ResetState();
    }

    @Override
    public boolean isZ80BusRequested() {
        return this.mdBus.isZ80BusRequested();
    }

    @Override
    public void setZ80ResetState(boolean z80ResetState) {
        this.mdBus.setZ80ResetState(z80ResetState);
    }

    @Override
    public void setZ80BusRequested(boolean z80BusRequested) {
        this.mdBus.setZ80BusRequested(z80BusRequested);
    }

    @Override
    public PsgProvider getPsg() {
        return this.mdBus.getPsg();
    }

    @Override
    public FmProvider getFm() {
        return this.mdBus.getFm();
    }

    @Override
    public SystemProvider getSystem() {
        return this.mdBus.getSystem();
    }

    @Override
    public MdVdpProvider getVdp() {
        return this.mdBus.getVdp();
    }

    @Override
    public int readIoPort(int port) {
        return this.mdBus.readIoPort(port);
    }

    private int readAdapterEnOn(int address, Size size) {
        int res = 0;
        if (address < 256) {
            res = this.bios68k.readBuffer(address, size);
            if (address >= 112 && address < 116) {
                res = this.readHIntVector(address, size);
            }
        } else if (address >= 0x880000 && address < 0x900000) {
            if (!DmaFifo68k.rv) {
                res = this.mdBus.read(address & 0x7FFFF, size);
            } else {
                LOG.warn("Ignoring read access to ROM mirror when RV={}, addr: {} {}", new Object[]{DmaFifo68k.rv, Util.th(address), size});
            }
        } else if (address >= 0x900000 && address < 0xA00000) {
            if (!DmaFifo68k.rv) {
                res = this.mdBus.read(this.bankSetShift | address & 0xFFFFF, size);
            } else {
                LOG.warn("Ignoring read access to ROM mirror bank when RV={}, addr: {} {}", new Object[]{DmaFifo68k.rv, Util.th(address), size});
            }
        } else if (address >= 0x840000 && address < 0x860000) {
            res = this.read32xWord(address & 0x1FFFF | 0x24000000, size);
        } else if (address >= 0x860000 && address < 0x880000) {
            res = this.read32xWord(address & 0x1FFFF | 0x24020000, size);
        } else if (address >= 10572032 && address < 10572160) {
            res = this.read32xWord(address & 0x7F | 0x20004000, size);
        } else if (address >= 10572160 && address < 10572288) {
            res = this.read32xWord(address & 0x7F | 0x20004100, size);
        } else if (address >= 10572288 && address < 10572800) {
            res = this.read32xWord(address & 0x1FF | 0x20004200, size);
        } else if (address >= 10563820 && address < 10563824) {
            assert (address == 10563820);
            res = 1296126547;
        } else {
            if (!DmaFifo68k.rv && address <= 0x3FFFFF) {
                LogHelper.logWarnOnce(LOG, "Ignoring read access to ROM when RV={}, addr: {} {}", new Object[]{DmaFifo68k.rv, Util.th(address), size});
                return size.getMask();
            }
            if (BufferUtil.assertionsEnabled && this.romReadQuirk(address)) {
                return size.getMask();
            }
            res = this.mdBus.read(address, size);
        }
        return res;
    }

    private int readAdapterEnOff(int address, Size size) {
        int res = 0;
        res = address >= 10563820 && address < 10563824 ? 1296126547 : (address >= 10572032 && address < 10572160 ? this.read32xWord(address & 0x7F | 0x20004000, size) : (address >= 10572160 && address < 10572288 ? this.read32xWord(address & 0x7F | 0x20004100, size) : (address >= 10572288 && address < 10572800 ? this.read32xWord(address & 0x1FF | 0x20004200, size) : this.mdBus.read(address, size))));
        return res;
    }

    private boolean romReadQuirk(int address) {
        if ((address & 0xFFFFCFFC) == 112 && address > 256) {
            LogHelper.logWarnOnce(LOG, "Unable to read from ROM address: {} when RV=1", Util.th(address));
            return true;
        }
        return false;
    }

    private void writeAdapterEnOn(int address, int data, Size size) {
        if (address >= 0x840000 && address < 0x860000) {
            this.write32xWord(address & 0x1FFFF | 0x24000000, data, size);
        } else if (address >= 0x860000 && address < 0x880000) {
            this.write32xWord(address & 0x1FFFF | 0x24020000, data, size);
        } else if (address >= 10572032 && address < 10572160) {
            int addr = address & 0x7F | 0x20004000;
            this.write32xWordDirect(addr, data, size);
            this.checkBankSetRegister(addr, size);
        } else if (address >= 10572160 && address < 10572288) {
            this.write32xWord(address & 0x7F | 0x20004100, data, size);
        } else if (address >= 10572288 && address < 10572800) {
            this.write32xWord(address & 0x1FF | 0x20004200, data, size);
        } else if (address >= 0x900000 && address < 0xA00000) {
            if (!DmaFifo68k.rv) {
                this.mdBus.write(address & 0xFFFFF | this.bankSetShift, data, size);
            } else {
                LOG.warn("Ignoring write access to ROM mirror bank when RV={}, addr: {}, addr68k: {}, val: {} {}", new Object[]{DmaFifo68k.rv, Util.th(address), Util.th(address & 0x7FFFF), Util.th(data), size});
            }
        } else if (address >= 0x880000 && address < 0x900000) {
            if (!DmaFifo68k.rv) {
                this.mdBus.write(address & 0x7FFFF, data, size);
            } else {
                LOG.warn("Ignoring write access to ROM mirror when RV={}, addr: {}, addr68k: {}, val: {} {}", new Object[]{DmaFifo68k.rv, Util.th(address), Util.th(address & 0x7FFFF), Util.th(data), size});
            }
        } else if (address >= 112 && address < 116) {
            Util.writeData(this.busContext.writeableHint, address & 3, data, size);
        } else {
            if (address < 256) {
                LogHelper.logWarnOnceWhenEn(LOG, "Ignoring write access to vector rom, RV={}, addr: {} {}", new Object[]{DmaFifo68k.rv, Util.th(address), size});
                return;
            }
            if (!DmaFifo68k.rv && address <= 0x3FFFFF) {
                LOG.warn("Ignoring write access to ROM when RV={}, addr: {} {}", new Object[]{DmaFifo68k.rv, Util.th(address), size});
                return;
            }
            this.mdBus.write(address, data, size);
        }
    }

    private void writeAdapterEnOff(int address, int data, Size size) {
        if (address >= 10572032 && address < 10572160) {
            int addr = address & 0x7F | 0x20004000;
            this.write32xWordDirect(addr, data, size);
            this.checkBankSetRegister(addr, size);
        } else if (address >= 10572160 && address < 10572288) {
            this.write32xWord(address & 0x7F | 0x20004100, data, size);
        } else if (address >= 10572288 && address < 10572800) {
            this.write32xWord(address & 0x1FF | 0x20004200, data, size);
        } else {
            this.mdBus.write(address, data, size);
        }
    }

    private void checkBankSetRegister(int address, Size size) {
        S32xDict.RegSpecS32x r = S32xDict.getRegSpec(BufferUtil.CpuDeviceAccess.M68K, address);
        if (r == S32xDict.RegSpecS32x.MD_BANK_SET) {
            int val = BufferUtil.readWordFromBuffer(this.s32XMMREG.regContext, r);
            this.busContext.bankSetValue = val & 3;
            this.bankSetShift = this.busContext.bankSetValue << 20;
        }
        assert (r != S32xDict.RegSpecS32x.MD_INT_CTRL || size != Size.LONG);
    }

    private void write32xWord(int address, int data, Size size) {
        if (this.s32XMMREG.fm > 0) {
            LogHelper.logWarnOnce(LOG, "Ignoring access to S32X memory from MD when FM={}, addr: {} {}", new Object[]{this.s32XMMREG.fm, Util.th(address), size});
            return;
        }
        this.write32xWordDirect(address, data, size);
    }

    private void write32xWordDirect(int address, int data, Size size) {
        if (size != Size.LONG) {
            this.s32XMMREG.write(address, data, size);
        } else {
            this.s32XMMREG.write(address, data >> 16 & 0xFFFF, Size.WORD);
            this.s32XMMREG.write(address + 2, data & 0xFFFF, Size.WORD);
        }
    }

    private int read32xWord(int address, Size size) {
        if (size != Size.LONG) {
            return this.s32XMMREG.read(address, size);
        }
        int res = this.s32XMMREG.read(address, Size.WORD) << 16;
        return res | this.s32XMMREG.read(address + 2, Size.WORD) & 0xFFFF;
    }

    private int readHIntVector(int address, Size size) {
        int res = Util.readData(this.busContext.writeableHint, 0, Size.LONG);
        res = res != -1 ? Util.readData(this.busContext.writeableHint, address & 3, size) : 0;
        return res;
    }

    @Override
    public int readRom(int address, Size size) {
        assert (address < 0x3FFFFF);
        return this.mdBus.read(address, size);
    }

    @Override
    public MarsVdp getMarsVdp() {
        return this.s32XMMREG.getVdp();
    }

    @Override
    public void onVdpEvent(BaseVdpAdapterEventSupport.VdpEvent event, Object value) {
        ((BaseVdpAdapterEventSupport.VdpEventListener)((Object)this.mdBus)).onVdpEvent(event, value);
        switch (event) {
            case V_BLANK_CHANGE: {
                this.s32XMMREG.setVBlank((Boolean)value);
                break;
            }
            case H_BLANK_CHANGE: {
                this.s32XMMREG.setHBlank((Boolean)value);
                break;
            }
            case VIDEO_MODE: {
                this.s32XMMREG.updateVideoMode((VideoMode)((Object)value));
            }
        }
    }

    public S32XMMREG getS32XMMREG() {
        return this.s32XMMREG;
    }

    @Override
    public void setBios68k(BiosHolder.BiosData bios68k) {
        this.bios68k = bios68k;
    }

    public PwmProvider getPwm() {
        return this.soundProvider.getPwm();
    }

    @Override
    public void saveContext(ByteBuffer buffer) {
        super.saveContext(buffer);
        buffer.put(Util.serializeObject(this.busContext));
    }

    @Override
    public void loadContext(ByteBuffer buffer) {
        super.loadContext(buffer);
        Serializable s = Util.deserializeObject(buffer);
        assert (s instanceof S32xBusContext);
        this.busContext = (S32xBusContext)s;
        this.bankSetShift = this.busContext.bankSetValue << 20;
    }

    public void resetSh2() {
        BufferUtil.CpuDeviceAccess cpu = MdRuntimeData.getAccessTypeExt();
        this.sh2.reset(this.masterCtx);
        this.sh2.reset(this.slaveCtx);
        this.masterCtx.devices.sh2MMREG.reset();
        this.slaveCtx.devices.sh2MMREG.reset();
        this.s32XMMREG.fm = 0;
        MdRuntimeData.setAccessTypeExt(cpu);
    }

    static class S32xBusContext
    implements Serializable {
        private static final long serialVersionUID = 3705180248407931780L;
        public final byte[] writeableHint = new byte[4];
        public int bankSetValue;

        S32xBusContext() {
        }
    }
}

