/*
 * Decompiled with CFR 0.152.
 */
package s32x.bus;

import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import omegadrive.util.BufferUtil;
import omegadrive.util.MdRuntimeData;
import omegadrive.util.Size;
import omegadrive.util.Util;
import s32x.Sh2MMREG;
import s32x.bus.Sh2Bus;
import s32x.sh2.Sh2Helper;
import s32x.sh2.cache.Sh2Cache;

public final class Sh2MemoryParallel
implements Sh2Bus {
    private boolean replayMode = false;
    private boolean active;
    private boolean dmaRunning;
    private final Sh2Bus memory;
    private final Map<Integer, RwCtx> map = new HashMap<Integer, RwCtx>();
    private int position = 0;

    public void setActive(boolean active) {
        this.active = active;
    }

    public void dmaRunning(boolean running) {
        this.dmaRunning = running;
    }

    public Sh2MemoryParallel(Sh2Bus memory) {
        this.memory = memory;
    }

    @Override
    public int read(int address, Size size) {
        if (!this.active || this.dmaRunning) {
            return this.memory.read(address, size);
        }
        if (address >>> 24 < 16) {
            address |= 0x20000000;
        }
        if (!this.replayMode) {
            int res;
            RwCtx entry = this.addEntry(address, 0, size, true);
            int delay = MdRuntimeData.getCpuDelayExt();
            entry.value = res = this.memory.read(address, size);
            entry.cpuDelay = MdRuntimeData.getCpuDelayExt() - delay;
            return res;
        }
        return this.checkEntry((int)address, (int)0, (Size)size, (boolean)true).value;
    }

    @Override
    public void resetSh2() {
        this.memory.resetSh2();
    }

    @Override
    public Sh2MMREG getSh2MMREGS(BufferUtil.CpuDeviceAccess master) {
        return this.memory.getSh2MMREGS(master);
    }

    @Override
    public void fetch(Sh2Helper.FetchResult ft, BufferUtil.CpuDeviceAccess cpu) {
        this.memory.fetch(ft, cpu);
    }

    @Override
    public int fetchDelaySlot(int pc, Sh2Helper.FetchResult ft, BufferUtil.CpuDeviceAccess cpu) {
        return this.memory.fetchDelaySlot(pc, ft, cpu);
    }

    @Override
    public void dataWrite(BufferUtil.CpuDeviceAccess cpu, int addr, int val, Size size) {
        this.memory.dataWrite(cpu, addr, val, size);
    }

    @Override
    public void invalidateCachePrefetch(Sh2Cache.CacheInvalidateContext ctx) {
        this.memory.invalidateCachePrefetch(ctx);
    }

    @Override
    public void newFrame() {
        this.memory.newFrame();
    }

    @Override
    public void write(int address, int val, Size size) {
        if (!this.active || this.dmaRunning) {
            this.memory.write(address, val, size);
            return;
        }
        if (address >>> 24 < 16) {
            address |= 0x20000000;
        }
        if (!this.replayMode) {
            RwCtx entry = this.addEntry(address, val, size, false);
            int delay = MdRuntimeData.getCpuDelayExt();
            this.memory.write(address, val, size);
            entry.cpuDelay = MdRuntimeData.getCpuDelayExt() - delay;
            return;
        }
        RwCtx entry = this.checkEntry(address, val, size, false);
        MdRuntimeData.addCpuDelayExt(entry.cpuDelay);
    }

    private RwCtx checkEntry(int address, int val, Size size, boolean read) {
        RwCtx ctx = this.map.get(this.position);
        assert (ctx != null);
        assert (ctx.address == address && ctx.size == size && ctx.read == read) : Util.th(address) + "," + Util.th(val) + " " + String.valueOf((Object)size) + " vs  " + String.valueOf(ctx);
        if (!read) assert ((ctx.value & size.getMask()) == (val & size.getMask())) : Util.th(address) + "," + Util.th(val) + " " + String.valueOf((Object)size) + " vs  " + String.valueOf(ctx);
        ++this.position;
        return ctx;
    }

    private RwCtx addEntry(int address, int val, Size size, boolean read) {
        RwCtx rwCtx = new RwCtx();
        rwCtx.address = address;
        rwCtx.size = size;
        rwCtx.value = val;
        rwCtx.position = this.position;
        rwCtx.read = read;
        this.map.put(this.position, rwCtx);
        ++this.position;
        assert (this.position < 100) : this.position;
        return rwCtx;
    }

    public void setReplayMode(boolean replayMode) {
        assert (this.replayMode != replayMode);
        this.replayMode = replayMode;
        this.position = 0;
    }

    public void clear() {
        this.map.clear();
        this.position = 0;
    }

    static class RwCtx {
        public int address;
        public int value;
        public int position;
        public int cpuDelay;
        public Size size;
        public boolean read;

        RwCtx() {
        }

        public String toString() {
            return new StringJoiner(", ", RwCtx.class.getSimpleName() + "[", "]").add("address=" + Util.th(this.address)).add("value=" + Util.th(this.value)).add("position=" + this.position).add("size=" + String.valueOf((Object)this.size)).add("read=" + this.read).toString();
        }
    }
}

