/*
 * Decompiled with CFR 0.152.
 */
package s32x.dict;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import omegadrive.util.LogHelper;
import omegadrive.util.MdRuntimeData;
import omegadrive.util.RegSpec;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.sh2.device.Sh2DeviceHelper;

public class Sh2Dict {
    private static final Logger LOG = LogHelper.getLogger(Sh2Dict.class.getSimpleName());
    public static Sh2DeviceHelper.Sh2DeviceType[] sh2RegDeviceMapping = new Sh2DeviceHelper.Sh2DeviceType[512];
    public static RegSpecSh2[] sh2RegMapping = new RegSpecSh2[512];
    public static final int BSC_LONG_WRITE_MASK = -1520828416;
    public static final int CAS_L1_OFFSET_16 = 33830;
    public static final int CAS_L2_OFFSET_16 = 33862;
    public static final int CAS_L3_OFFSET_16 = 33894;
    public static final int CAS_L1_OFFSET_32 = 34888;
    public static final int CAS_L2_OFFSET_32 = 34952;
    public static final int CAS_L3_OFFSET_32 = 35016;
    public static final Map<Integer, Integer> dramModeRegsSpec = ImmutableMap.of((Object)33830, (Object)0, (Object)33862, (Object)0, (Object)33894, (Object)0, (Object)34888, (Object)0, (Object)34952, (Object)0, (Object)35016, (Object)0);

    public static boolean checkName(int reg) {
        if (sh2RegMapping[reg & 0x1FF] == null) {
            LOG.warn("{} SH2 mmreg unknown reg: {}", (Object)MdRuntimeData.getAccessTypeExt(), (Object)Util.th(reg));
        }
        return true;
    }

    public static void logAccess(String type, int reg, int value, Size size) {
        String s = String.valueOf((Object)MdRuntimeData.getAccessTypeExt()) + " SH2 reg " + type + " " + String.valueOf((Object)size) + ", (" + String.valueOf((Object)sh2RegMapping[reg & 0x1FF]) + ") " + Util.th(reg) + ": " + Util.th(value);
        LOG.info(s);
    }

    public static enum RegSpecSh2 {
        SCI_SMR(65024, "SCI_SMR", Size.BYTE),
        SCI_BRR(65025, "SCI_BRR", Size.BYTE),
        SCI_SCR(65026, "SCI_SCR", Size.BYTE),
        SCI_TDR(65027, "SCI_TDR", Size.BYTE),
        SCI_SSR(65028, "SCI_SSR", Size.BYTE),
        SCI_RDR(65029, "SCI_RDR", Size.BYTE),
        FRT_TIER(65040, "FRT_TIER", Size.BYTE),
        FRT_FTCSR(65041, "FRT_FTCSR", Size.BYTE),
        FRT_FRCH(65042, "FRT_FRCH", Size.BYTE),
        FRT_FRCL(65043, "FRT_FRCL", Size.BYTE),
        FRT_OCRAB_H(65044, "FRT_OCRAB_H", Size.BYTE),
        FRT_OCRAB_L(65045, "FRT_OCRAB_L", Size.BYTE),
        FRT_TCR(65046, "FRT_TCR", Size.BYTE),
        FRT_TOCR(65047, "FRT_TOCR", Size.BYTE),
        FRT_ICR_H(65048, "FRT_ICR_H", Size.BYTE),
        FRT_ICR_L(65049, "FRT_ICR_L", Size.BYTE),
        WDT_WTCSR(65152, "WDT_WTCSR", Size.BYTE),
        WDT_WTCNT(65153, "WDT_WTCNT", Size.BYTE),
        WDT_RSTCSR(65154, "WDT_RSTCSR", Size.WORD),
        INTC_IPRA(65250, "INTC_IPRA", Size.WORD, 65520),
        INTC_IPRB(65120, "INTC_IPRB", Size.WORD, 65280),
        INTC_VCRA(65122, "INTC_VCRA", Size.WORD, 32639),
        INTC_VCRB(65124, "INTC_VCRB", Size.WORD, 32639),
        INTC_VCRC(65126, "INTC_VCRC", Size.WORD, 32639),
        INTC_VCRD(65128, "INTC_VCRD", Size.WORD, 32512),
        INTC_VCRWDT(65252, "INTC_VCRWDT", Size.WORD, 32639),
        INTC_VCRDIV(65292, "INTC_VCRDIV", Size.LONG, -65536),
        INTC_VCRDMA0(65440, "INTC_VCRDMA0", Size.LONG, -256),
        INTC_VCRDMA1(65448, "INTC_VCRDMA1", Size.LONG, -256),
        INTC_ICR(65248, "INTC_ICR", Size.WORD, 33025),
        BSC_BCR1(65504, "BSC_BCR1", Size.LONG, 40951),
        BSC_BCR2(65508, "BSC_BCR2", Size.LONG, 252),
        BSC_WCR(65512, "BSC_WCR", Size.LONG),
        BSC_MCR(65516, "BSC_MCR", Size.LONG, 65276),
        BSC_RTCSR(65520, "BSC_RTCSR", Size.LONG, 248),
        BSC_RTCNT(65524, "BSC_RTCNT", Size.LONG, 255),
        BSC_RTCOR(65528, "BSC_RTCOR", Size.LONG, 255),
        DIV_DVSR(65280, "DIV_DVSR", Size.LONG),
        DIV_DVDNT(65284, "DIV_DVDNT", Size.LONG),
        DIV_DVCR(65288, "DIV_DVCR", Size.LONG, 3),
        DIV_DVDNTH(65296, "DIV_DVDNTH", Size.LONG),
        DIV_DVDNTL(65300, "DIV_DVDNTL", Size.LONG),
        DIV_DVDNTUH(65304, "DIV_DVDNTUH", Size.LONG),
        DIV_DVDNTUL(65308, "DIV_DVDNTUL", Size.LONG),
        UBC_BARAH(65344, "UBC_BARAH", Size.WORD),
        UBC_BARAL(65346, "UBC_BARAL", Size.WORD),
        UBC_BBRA(65352, "UBC_BBRA", Size.WORD),
        UBC_BARBH(65376, "UBC_BARBH", Size.WORD),
        UBC_BBRB(65384, "UBC_BBRB", Size.WORD),
        DMA_DRCR0(65137, "DMA_DRCR0", Size.BYTE),
        DMA_DRCR1(65138, "DMA_DRCR1", Size.BYTE),
        DMA_SAR0(65408, "DMA_SAR0", Size.LONG),
        DMA_SAR1(65424, "DMA_SAR1", Size.LONG),
        DMA_DAR0(65412, "DMA_DAR0", Size.LONG),
        DMA_DAR1(65428, "DMA_DAR1", Size.LONG),
        DMA_TCR0(65416, "DMA_TCR0", Size.LONG),
        DMA_TCR1(65432, "DMA_TCR1", Size.LONG),
        DMA_CHCR0(65420, "DMA_CHCR0", Size.LONG),
        DMA_CHCR1(65436, "DMA_CHCR1", Size.LONG),
        DMA_DMAOR(65456, "DMA_DMAOR", Size.LONG),
        DMA_VRCDMA0(65440, "DMA_VRCDMA0", Size.LONG),
        DMA_VRCDMA1(65448, "DMA_VRCDMA1", Size.LONG),
        NONE_SBYCR(65169, "NONE_SBYCR", Size.BYTE),
        NONE_CCR(65170, "NONE_CCR", Size.BYTE),
        NONE_FE93(65171, "NONE_FE93", Size.BYTE);

        public static final int REG_MASK = 511;
        public final RegSpec regSpec;
        public final int addr;

        private RegSpecSh2(int addr, String name, Size size) {
            this(addr, name, size, size.getMask());
        }

        private RegSpecSh2(int addr, String name, Size size, int writeMask) {
            this.regSpec = new RegSpec(name, addr, 511, writeMask, 0, size);
            this.addr = this.regSpec.bufferAddr;
            this.init();
        }

        private void init() {
            int addrLen = this.regSpec.regSize.getByteSize();
            String device = this.regSpec.name.split("_")[0];
            for (int i = this.regSpec.bufferAddr; i < this.regSpec.bufferAddr + addrLen; ++i) {
                Sh2Dict.sh2RegMapping[i] = this;
                Sh2Dict.sh2RegDeviceMapping[i] = Sh2DeviceHelper.Sh2DeviceType.valueOf(device);
            }
        }

        public String getName() {
            return this.regSpec.name;
        }
    }
}

