/*
 * Decompiled with CFR 0.152.
 */
package s32x.pwm;

import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.nio.ByteBuffer;
import omegadrive.sound.PwmProvider;
import omegadrive.util.BufferUtil;
import omegadrive.util.Fifo;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.S32XMMREG;
import s32x.dict.S32xDict;
import s32x.event.PollSysEventManager;
import s32x.pwm.PwmUtil;
import s32x.savestate.Gs32xStateHandler;
import s32x.sh2.device.DmaC;
import s32x.sh2.device.IntControl;
import s32x.sh2.drc.Sh2DrcBlockOptimizer;

public class Pwm
implements BufferUtil.StepDevice {
    private static final Logger LOG = LogHelper.getLogger(Pwm.class.getSimpleName());
    public static boolean PWM_USE_BLIP = false;
    private static final int PWM_DMA_CHANNEL = 1;
    private static final int chLeft = PwmChannel.LEFT.ordinal();
    private static final int chRight = PwmChannel.RIGHT.ordinal();
    private static final int PWM_FIFO_SIZE = 3;
    private static final int PWM_FIFO_FULL_BIT_POS = 15;
    private static final int PWM_FIFO_EMPTY_BIT_POS = 14;
    public static final int CYCLE_LIMIT = 400;
    public static final int CYCLE_22khz = 1042;
    public static final int SAMPLE_LIMIT_DELTA = 5;
    private static final PwmChannelSetup[] chanVals = PwmChannelSetup.values();
    private final ByteBuffer sysRegsMd;
    private final ByteBuffer sysRegsSh2;
    private IntControl[] intControls;
    private DmaC[] dmac;
    private PwmContext ctx;
    private int pwmSamplesPerFrame = 0;
    private int stepsPerFrame = 0;
    private int dreqPerFrame = 0;
    private static final boolean verbose = false;
    private PwmProvider playSupport = PwmProvider.NO_SOUND;
    private final PwmChannelMap fifoMapLeft = new PwmChannelMap();
    private final PwmChannelMap fifoMapRight = new PwmChannelMap();

    public Pwm(S32XMMREG.RegContext regContext) {
        this.sysRegsMd = regContext.sysRegsMd;
        this.sysRegsSh2 = regContext.sysRegsSh2;
        this.ctx = new PwmContext();
        Gs32xStateHandler.addDevice(this);
        this.init();
    }

    public int read(BufferUtil.CpuDeviceAccess cpu, S32xDict.RegSpecS32x regSpec, int address, Size size) {
        int res = BufferUtil.readBuffer(this.sysRegsMd, address, size);
        assert (res == BufferUtil.readBuffer(this.sysRegsSh2, address, size));
        return res;
    }

    public void write(BufferUtil.CpuDeviceAccess cpu, S32xDict.RegSpecS32x regSpec, int reg, int value, Size size) {
        switch (size) {
            case BYTE: {
                this.writeByte(cpu, regSpec, reg, value);
                break;
            }
            case WORD: {
                this.writeWord(cpu, regSpec, reg, value);
                break;
            }
            case LONG: {
                this.writeWord(cpu, regSpec, reg, value >> 16 & 0xFFFF);
                this.writeWord(cpu, S32xDict.getRegSpec(cpu, regSpec.addr + 2), reg + 2, value & 0xFFFF);
            }
        }
    }

    public void writeByte(BufferUtil.CpuDeviceAccess cpu, S32xDict.RegSpecS32x regSpec, int reg, int value) {
        switch (regSpec) {
            case PWM_CTRL: {
                this.handlePwmControl(cpu, reg, value, Size.BYTE);
                break;
            }
            case PWM_CYCLE: {
                assert (cpu.regSide == BufferUtil.S32xRegSide.MD) : regSpec;
                this.handlePartialByteWrite(reg, value);
                if (regSpec != S32xDict.RegSpecS32x.PWM_CYCLE) break;
                int val = Util.readBufferWord(this.sysRegsMd, regSpec.addr);
                this.handlePwmCycleWord(cpu, val);
                break;
            }
            case PWM_RCH_PW: 
            case PWM_LCH_PW: 
            case PWM_MONO: {
                this.handlePartialByteWrite(reg, value);
                if ((reg & 1) != 1) break;
                int val = Util.readBufferWord(this.sysRegsMd, regSpec.addr);
                this.writeWord(cpu, regSpec, regSpec.addr, val);
                this.updateFifoRegs();
                break;
            }
            default: {
                LOG.error("{} PWM write {} {}: {} {}", new Object[]{cpu, regSpec.getName(), Util.th(reg), Util.th(value), Size.BYTE});
            }
        }
    }

    private void handlePartialByteWrite(int reg, int value) {
        boolean even;
        boolean bl = even = (reg & 1) == 0;
        if (even) {
            BufferUtil.writeBuffers(this.sysRegsMd, this.sysRegsSh2, reg, value & 0xF, Size.BYTE);
            return;
        }
        BufferUtil.writeBuffers(this.sysRegsMd, this.sysRegsSh2, reg, value & 0xFF, Size.BYTE);
    }

    private void writeWord(BufferUtil.CpuDeviceAccess cpu, S32xDict.RegSpecS32x regSpec, int reg, int value) {
        switch (regSpec) {
            case PWM_CTRL: {
                this.handlePwmControl(cpu, reg, value, Size.WORD);
                break;
            }
            case PWM_CYCLE: {
                this.handlePwmCycleWord(cpu, value);
                break;
            }
            case PWM_MONO: {
                this.writeMono(value);
                break;
            }
            case PWM_LCH_PW: {
                this.writeFifo(this.ctx.fifoLeft, value);
                break;
            }
            case PWM_RCH_PW: {
                this.writeFifo(this.ctx.fifoRight, value);
                break;
            }
            default: {
                BufferUtil.writeBuffers(this.sysRegsMd, this.sysRegsSh2, regSpec.addr, value, Size.WORD);
            }
        }
    }

    private void handlePwmCycleWord(BufferUtil.CpuDeviceAccess cpu, int value) {
        BufferUtil.writeBuffers(this.sysRegsMd, this.sysRegsSh2, S32xDict.RegSpecS32x.PWM_CYCLE.addr, value &= 0xFFF, Size.WORD);
        int prevCycle = this.ctx.cycle;
        this.ctx.cycle = value - 1 & 0xFFF;
        if (this.ctx.cycle < 400) {
            LOG.warn("PWM cycle not supported: {}, limit: {}", (Object)this.ctx.cycle, (Object)400);
        }
        if (prevCycle != this.ctx.cycle) {
            this.handlePwmEnable(true);
        }
    }

    private void handlePwmControl(BufferUtil.CpuDeviceAccess cpu, int reg, int value, Size size) {
        switch (cpu.regSide) {
            case MD: {
                this.handlePwmControlMd(cpu, reg, value, size);
                break;
            }
            default: {
                this.handlePwmControlSh2(cpu, reg, value, size);
            }
        }
        this.handlePwmEnable(false);
    }

    private void handlePwmControlMd(BufferUtil.CpuDeviceAccess cpu, int reg, int value, Size size) {
        assert (size != Size.LONG);
        if (size == Size.BYTE && (reg & 1) == 0) {
            LOG.info("{} ignored write to {} {}, read only byte: val {} {}", new Object[]{cpu, S32xDict.RegSpecS32x.PWM_CTRL, Util.th(reg), Util.th(value), size});
            return;
        }
        int val = Util.readBufferWord(this.sysRegsMd, S32xDict.RegSpecS32x.PWM_CTRL.addr) & 0xFFF0;
        BufferUtil.writeBuffers(this.sysRegsMd, this.sysRegsSh2, reg, val |= value & 0xF, size);
        value = Util.readBufferWord(this.sysRegsMd, S32xDict.RegSpecS32x.PWM_CTRL.addr);
        this.ctx.channelMap[Pwm.chLeft] = chanVals[value & 3];
        this.ctx.channelMap[Pwm.chRight] = chanVals[value >> 2 & 3];
        this.updateChannelMap();
    }

    private void handlePwmControlSh2(BufferUtil.CpuDeviceAccess cpu, int reg, int val, Size size) {
        int mask;
        switch (size) {
            case WORD: {
                int n = 3983;
                break;
            }
            case BYTE: {
                int n;
                if ((reg & 1) == 1) {
                    n = 143;
                    break;
                }
                n = 15;
                break;
            }
            default: {
                int n = mask = 0;
            }
        }
        assert (size != Size.LONG);
        BufferUtil.writeBuffers(this.sysRegsMd, this.sysRegsSh2, reg, val & mask, size);
        int value = Util.readBufferWord(this.sysRegsMd, S32xDict.RegSpecS32x.PWM_CTRL.addr);
        this.ctx.dreqEn = (value >> 7 & 1) > 0;
        int ival = value >> 8 & 0xF;
        this.ctx.interruptInterval = ival == 0 ? 16 : ival;
        this.ctx.channelMap[Pwm.chLeft] = chanVals[value & 3];
        this.ctx.channelMap[Pwm.chRight] = chanVals[value >> 2 & 3];
        this.updateChannelMap();
    }

    private void handlePwmEnable(boolean cycleChanged) {
        boolean wasEnabled = this.ctx.pwmEnable;
        boolean bl = this.ctx.pwmEnable = this.ctx.cycle > 0 && (this.ctx.channelMap[chLeft].isValid() || this.ctx.channelMap[chRight].isValid());
        if (!wasEnabled && this.ctx.pwmEnable || cycleChanged) {
            assert (this.ctx.interruptInterval > 0);
            this.ctx.sh2TicksToNextPwmSample = this.ctx.cycle;
            this.ctx.sh2ticksToNextPwmInterrupt = this.ctx.interruptInterval;
            this.ctx.latestPwmValue[0] = this.ctx.latestPwmValue[1] = this.ctx.cycle >> 1;
            this.resetFifo();
            this.updateFifoRegs();
            this.playSupport.updatePwmCycle(this.ctx.cycle);
            this.updateChannelMap();
        }
    }

    private void updateChannelMap() {
        switch (this.ctx.channelMap[chLeft]) {
            case SAME: {
                this.fifoMapLeft.fifo = this.ctx.fifoLeft;
                this.fifoMapLeft.channel = PwmChannel.LEFT;
                break;
            }
            case FLIP: {
                this.fifoMapLeft.fifo = this.ctx.fifoRight;
                this.fifoMapLeft.channel = PwmChannel.RIGHT;
                break;
            }
            default: {
                this.fifoMapLeft.fifo = PwmUtil.EMPTY_FIFO;
                this.fifoMapLeft.channel = null;
            }
        }
        switch (this.ctx.channelMap[chRight]) {
            case SAME: {
                this.fifoMapRight.fifo = this.ctx.fifoRight;
                this.fifoMapRight.channel = PwmChannel.RIGHT;
                break;
            }
            case FLIP: {
                this.fifoMapRight.fifo = this.ctx.fifoLeft;
                this.fifoMapRight.channel = PwmChannel.LEFT;
                break;
            }
            default: {
                this.fifoMapRight.fifo = PwmUtil.EMPTY_FIFO;
                this.fifoMapRight.channel = null;
            }
        }
    }

    private void resetFifo() {
        this.ctx.fifoRight.clear();
        this.ctx.fifoLeft.clear();
    }

    private void writeFifo(Fifo<Integer> fifo, int value) {
        if (!this.ctx.pwmEnable) {
            return;
        }
        if (fifo.isFull()) {
            fifo.pop();
            return;
        }
        value = Ints.constrainToRange((int)value, (int)5, (int)4090);
        assert (value >= 0);
        fifo.push(Util.getFromIntegerCache(value - 1 & 0xFFF));
        this.updateFifoRegs();
    }

    private int readMono() {
        return this.readFifo(this.ctx.fifoLeft, PwmChannel.LEFT) + this.readFifo(this.ctx.fifoRight, PwmChannel.RIGHT) >> 1;
    }

    private int readFifo(Fifo<Integer> fifo, PwmChannel chan) {
        int res;
        if (fifo.isEmpty()) {
            return chan != null ? this.ctx.latestPwmValue[chan.ordinal()] : this.ctx.cycle >> 1;
        }
        this.ctx.latestPwmValue[chan.ordinal()] = res = fifo.pop().intValue();
        this.updateFifoRegs();
        return res;
    }

    private void updateFifoRegs() {
        int regValue = this.ctx.fifoLeft.isFullBit() << 15 | this.ctx.fifoLeft.isEmptyBit() << 14;
        BufferUtil.writeBuffers(this.sysRegsMd, this.sysRegsSh2, S32xDict.RegSpecS32x.PWM_LCH_PW.addr, regValue, Size.WORD);
        regValue = this.ctx.fifoRight.isFullBit() << 15 | this.ctx.fifoRight.isEmptyBit() << 14;
        BufferUtil.writeBuffers(this.sysRegsMd, this.sysRegsSh2, S32xDict.RegSpecS32x.PWM_RCH_PW.addr, regValue, Size.WORD);
        this.updateMono();
    }

    private void updateMono() {
        int fifoFull = (this.ctx.fifoLeft.isFullBit() | this.ctx.fifoRight.isFullBit()) << 15;
        int fifoEmpty = (this.ctx.fifoLeft.isEmptyBit() & this.ctx.fifoRight.isEmptyBit()) << 14;
        int regValue = fifoFull | fifoEmpty;
        BufferUtil.writeBuffers(this.sysRegsMd, this.sysRegsSh2, S32xDict.RegSpecS32x.PWM_MONO.addr, regValue, Size.WORD);
        this.updatePolling();
    }

    private void updatePolling() {
        if (!Sh2DrcBlockOptimizer.PollType.PWM.supported) {
            return;
        }
        switch (PollSysEventManager.instance.anyPollerActive()) {
            case 1: {
                this.checkPoller(BufferUtil.CpuDeviceAccess.MASTER);
                break;
            }
            case 2: {
                this.checkPoller(BufferUtil.CpuDeviceAccess.SLAVE);
                break;
            }
            case 3: {
                this.checkPoller(BufferUtil.CpuDeviceAccess.MASTER);
                this.checkPoller(BufferUtil.CpuDeviceAccess.SLAVE);
            }
        }
    }

    private void checkPoller(BufferUtil.CpuDeviceAccess cpu) {
        Sh2DrcBlockOptimizer.PollerCtx c = PollSysEventManager.instance.getPoller(cpu);
        if (c.isPollingActive() && PollSysEventManager.SysEvent.PWM == c.event) {
            PollSysEventManager.instance.fireSysEvent(cpu, c.event);
        }
    }

    public void writeMono(int value) {
        this.writeFifo(this.ctx.fifoLeft, value);
        this.writeFifo(this.ctx.fifoRight, value);
    }

    public void newFrame() {
        this.pwmSamplesPerFrame = 0;
        this.stepsPerFrame = 0;
        this.dreqPerFrame = 0;
        this.playSupport.newFrame();
    }

    @Override
    public void step(int cycles) {
        while (this.ctx.pwmEnable && cycles-- > 0) {
            this.stepOne();
        }
    }

    private void stepOne() {
        if (--this.ctx.sh2TicksToNextPwmSample == 0) {
            this.ctx.sh2TicksToNextPwmSample = this.ctx.cycle;
            ++this.pwmSamplesPerFrame;
            this.ctx.ls = Math.min(this.ctx.cycle - 5, this.readFifo(this.fifoMapLeft.fifo, this.fifoMapLeft.channel) + 5);
            this.ctx.rs = Math.min(this.ctx.cycle - 5, this.readFifo(this.fifoMapRight.fifo, this.fifoMapRight.channel) + 5);
            assert (this.ctx.ls >= 5 && this.ctx.rs >= 5);
            if (PWM_USE_BLIP) {
                this.playSupport.playSample(this.ctx.ls, this.ctx.rs);
            }
            if (--this.ctx.sh2ticksToNextPwmInterrupt == 0) {
                this.intControls[BufferUtil.CpuDeviceAccess.MASTER.ordinal()].setIntPending(IntControl.Sh2Interrupt.PWM_06, true);
                this.intControls[BufferUtil.CpuDeviceAccess.SLAVE.ordinal()].setIntPending(IntControl.Sh2Interrupt.PWM_06, true);
                this.ctx.sh2ticksToNextPwmInterrupt = this.ctx.interruptInterval;
                this.dreq();
            }
        }
        if (!PWM_USE_BLIP && --this.ctx.sh2TicksToNext22khzSample == 0) {
            this.playSupport.playSample(this.ctx.ls, this.ctx.rs);
            this.ctx.sh2TicksToNext22khzSample = 1042;
        }
    }

    private void dreq() {
        if (this.ctx.dreqEn) {
            this.dmac[BufferUtil.CpuDeviceAccess.MASTER.ordinal()].dmaReqTriggerPwm(1, true);
            this.dmac[BufferUtil.CpuDeviceAccess.SLAVE.ordinal()].dmaReqTriggerPwm(1, true);
            ++this.dreqPerFrame;
        }
    }

    public void setIntControls(IntControl ... intControls) {
        this.intControls = intControls;
    }

    public void setDmac(DmaC ... dmac) {
        this.dmac = dmac;
    }

    public void setPwmProvider(PwmProvider p) {
        this.playSupport = p;
        this.playSupport.updatePwmCycle(this.ctx.cycle);
    }

    @Override
    public void saveContext(ByteBuffer buffer) {
        BufferUtil.StepDevice.super.saveContext(buffer);
        buffer.put(Util.serializeObject(this.ctx));
    }

    @Override
    public void loadContext(ByteBuffer buffer) {
        BufferUtil.StepDevice.super.loadContext(buffer);
        Serializable s = Util.deserializeObject(buffer);
        assert (s instanceof PwmContext);
        this.ctx = (PwmContext)s;
        this.updateChannelMap();
    }

    @Override
    public void init() {
        BufferUtil.writeBuffers(this.sysRegsMd, this.sysRegsSh2, S32xDict.RegSpecS32x.PWM_LCH_PW.addr, 16384, Size.WORD);
        BufferUtil.writeBuffers(this.sysRegsMd, this.sysRegsSh2, S32xDict.RegSpecS32x.PWM_RCH_PW.addr, 16384, Size.WORD);
        BufferUtil.writeBuffers(this.sysRegsMd, this.sysRegsSh2, S32xDict.RegSpecS32x.PWM_MONO.addr, 16384, Size.WORD);
        this.handlePwmControlSh2(BufferUtil.CpuDeviceAccess.MASTER, S32xDict.RegSpecS32x.PWM_CTRL.addr, 0, Size.WORD);
    }

    @Override
    public void reset() {
        this.init();
        this.playSupport.reset();
        LOG.info("PWM reset done");
    }

    static class PwmChannelMap {
        public Fifo<Integer> fifo;
        public PwmChannel channel;

        PwmChannelMap() {
        }
    }

    static class PwmContext
    implements Serializable {
        private static final long serialVersionUID = -4421577765971810509L;
        private final Fifo<Integer> fifoLeft = Fifo.createIntegerFixedSizeFifo(3);
        private final Fifo<Integer> fifoRight = Fifo.createIntegerFixedSizeFifo(3);
        private final PwmChannelSetup[] channelMap = new PwmChannelSetup[]{PwmChannelSetup.OFF, PwmChannelSetup.OFF};
        private boolean pwmEnable;
        private boolean dreqEn;
        private int cycle = 0;
        private int interruptInterval;
        private int sh2TicksToNextPwmSample;
        private int sh2ticksToNextPwmInterrupt;
        private int sh2TicksToNext22khzSample = 1042;
        private int rs;
        private int ls;
        private final int[] latestPwmValue = new int[PwmChannel.values().length];

        PwmContext() {
        }
    }

    static enum PwmChannelSetup {
        OFF,
        SAME,
        FLIP,
        INVALID;


        public boolean isValid() {
            return this == SAME || this == FLIP;
        }
    }

    static enum PwmChannel {
        LEFT,
        RIGHT;

    }
}

