/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicReference;
import omegadrive.cpu.CpuFastDebug;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.sh2.Sh2Context;
import s32x.sh2.Sh2Debug;
import s32x.sh2.Sh2Disassembler;
import s32x.sh2.drc.Sh2Block;

public class Sh2Helper {
    private static final Logger LOG = LogHelper.getLogger(Sh2Helper.class.getSimpleName());
    public static final Sh2Disassembler disasm = new Sh2Disassembler();
    private static final String simpleFormat = "%s %08x\t%04x\t%s";
    private static final Sh2PcInfoWrapper[] EMPTY_WRAPPER = new Sh2PcInfoWrapper[0];
    public static final Sh2PcInfoWrapper SH2_NOT_VISITED = new Sh2PcInfoWrapper(0, 0);
    private static Sh2PcInfoWrapper[][] piwArr = Sh2Helper.createPcInfoWrapper();

    public static void clear() {
        piwArr = Sh2Helper.createWrapper(Sh2Debug.createContext());
    }

    private static Sh2PcInfoWrapper[][] createPcInfoWrapper() {
        if (piwArr == null) {
            piwArr = Sh2Helper.createWrapper(Sh2Debug.createContext());
        }
        return piwArr;
    }

    public static Sh2PcInfoWrapper[][] getPcInfoWrapper() {
        assert (piwArr != null);
        return piwArr;
    }

    private static Sh2PcInfoWrapper[][] createWrapper(CpuFastDebug.CpuDebugContext ctx) {
        Sh2PcInfoWrapper[][] pcInfoWrapper = new Sh2PcInfoWrapper[ctx.pcAreasNumber][0];
        assert (EMPTY_WRAPPER != null);
        Arrays.fill((Object[])pcInfoWrapper, EMPTY_WRAPPER);
        for (int i = 0; i < ctx.pcAreasMaskMap.length; ++i) {
            int pcAreaSize = ctx.pcAreasMaskMap[i] + 1;
            if (pcAreaSize <= 1) continue;
            pcInfoWrapper[i] = new Sh2PcInfoWrapper[pcAreaSize];
            Arrays.fill(pcInfoWrapper[i], SH2_NOT_VISITED);
        }
        return pcInfoWrapper;
    }

    public static boolean isValidPc(int pc, BufferUtil.CpuDeviceAccess cpu) {
        assert ((pc & 1) == 0) : Util.th(pc);
        int piwPc = pc | cpu.ordinal();
        return piwArr[piwPc >>> 24].length > 0;
    }

    public static Sh2PcInfoWrapper getOrDefault(int pc, BufferUtil.CpuDeviceAccess cpu) {
        assert ((pc & 1) == 0) : Util.th(pc);
        int piwPc = pc | cpu.ordinal();
        Sh2PcInfoWrapper[] piwSubArr = piwArr[piwPc >>> 24];
        if (piwSubArr.length == 0) {
            return SH2_NOT_VISITED;
        }
        Sh2PcInfoWrapper piw = piwSubArr[piwPc & Sh2Debug.pcAreaMaskMap[piwPc >>> 24]];
        assert (piw == SH2_NOT_VISITED || piw.pcMasked == (pc & Sh2Debug.pcAreaMaskMap[pc >>> 24])) : Util.th(piwPc) + "," + Util.th(piw.pcMasked);
        return piw;
    }

    public static Sh2PcInfoWrapper get(int pc, BufferUtil.CpuDeviceAccess cpu) {
        assert ((pc & 1) == 0) : Util.th(pc);
        int piwPc = pc | cpu.ordinal();
        Sh2PcInfoWrapper piw = piwArr[piwPc >>> 24][piwPc & Sh2Debug.pcAreaMaskMap[piwPc >>> 24]];
        assert (piw == SH2_NOT_VISITED || piw.pcMasked == (pc & Sh2Debug.pcAreaMaskMap[pc >>> 24])) : Util.th(piwPc) + "," + Util.th(piw.pcMasked);
        return piw;
    }

    public static Sh2PcInfoWrapper getOrCreate(int pc, BufferUtil.CpuDeviceAccess cpu) {
        Sh2PcInfoWrapper piw = Sh2Helper.get(pc, cpu);
        assert (piw != null);
        if (piw == SH2_NOT_VISITED) {
            int piwPc = pc | cpu.ordinal();
            Sh2Helper.piwArr[piw.area][piw.pcMasked | cpu.ordinal()] = piw = new Sh2PcInfoWrapper(pc >>> 24, pc & Sh2Debug.pcAreaMaskMap[pc >>> 24]);
        }
        assert (piw.pcMasked == (pc & Sh2Debug.pcAreaMaskMap[pc >>> 24]));
        return piw;
    }

    public static void printInst(Sh2Context ctx) {
        System.out.println(Sh2Helper.getInstString(ctx));
    }

    public static String getInstString(Sh2Context ctx) {
        assert (ctx.opcode > 0);
        return String.format(simpleFormat, ctx.sh2ShortCode, ctx.PC, ctx.opcode, disasm.disassemble(ctx.PC, ctx.opcode));
    }

    public static String getInstString(int pc, int opcode) {
        return disasm.disassemble(pc, opcode);
    }

    public static String getInstString(String sh2Type, int pc, int opcode) {
        return String.format(simpleFormat, sh2Type, pc, opcode, disasm.disassemble(pc, opcode));
    }

    public static void printState(Sh2Context ctx) {
        System.out.println(Sh2Helper.toDebuggingString(ctx));
    }

    public static StringBuilder toListOfInst(int pc, int ... opcodes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < opcodes.length; ++i) {
            sb.append(Sh2Helper.getInstString("", pc + (i << 1), opcodes[i])).append("\n");
        }
        return sb;
    }

    public static StringBuilder toListOfInst(Sh2Block ctx) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ctx.prefetchWords.length; ++i) {
            int pc = ctx.start + (i << 1);
            pc = pc != ctx.pcMasked ? pc : ctx.prefetchPc;
            sb.append(Sh2Helper.getInstString("", pc, ctx.prefetchWords[i])).append("\n");
        }
        return sb;
    }

    public static String toDebuggingString(Sh2Context ctx) {
        StringBuilder sb = new StringBuilder("\n");
        sb.append(Sh2Helper.getInstString(ctx.sh2ShortCode, ctx.PC, ctx.opcode)).append("\n");
        sb.append(String.format("PC : %08x\t", ctx.PC));
        sb.append(String.format("GBR: %08x\t", ctx.GBR));
        sb.append(String.format("VBR: %08x\t", ctx.VBR));
        sb.append(String.format("SR : %08x\t", ctx.SR));
        sb.append(((ctx.SR & 1) != 0 ? "T" : "-") + ((ctx.SR & 2) != 0 ? "S" : "-") + ((ctx.SR & 0x100) != 0 ? "Q" : "-") + ((ctx.SR & 0x200) != 0 ? "M" : "-"));
        sb.append("\n");
        for (int i = 0; i < 16; ++i) {
            sb.append(String.format("R%02d: %08x\t", i, ctx.registers[i]));
            if (i != 7) continue;
            sb.append("\n");
        }
        sb.append("\n");
        sb.append(String.format("MCH: %08x\t", ctx.MACH));
        sb.append(String.format("MCL: %08x\t", ctx.MACL));
        sb.append(String.format("PR : %08x\t", ctx.PR));
        sb.append("\n");
        return sb.toString();
    }

    public static final class Sh2PcInfoWrapper
    extends CpuFastDebug.PcInfoWrapper {
        public Sh2Block block = Sh2Block.INVALID_BLOCK;
        public Map<Integer, Sh2Block> knownBlocks = Collections.emptyMap();
        private static final boolean verbose = false;
        public static final int HASH_CODE_MASK = 65535;

        public Sh2PcInfoWrapper(int area, int pcMasked) {
            super(area, pcMasked);
        }

        public void setBlock(Sh2Block block) {
            assert (this != SH2_NOT_VISITED);
            this.block = block;
        }

        public void invalidateBlock() {
            if (this.block != Sh2Block.INVALID_BLOCK) {
                this.block.invalidate();
                this.block = Sh2Block.INVALID_BLOCK;
            }
        }

        public Sh2Block addToKnownBlocks(Sh2Block b) {
            assert (this != SH2_NOT_VISITED);
            if (this.knownBlocks == Collections.EMPTY_MAP) {
                this.knownBlocks = new HashMap<Integer, Sh2Block>(1);
            }
            Sh2Block prev = this.knownBlocks.putIfAbsent(b.hashCodeWords & 0xFFFF, b);
            assert (prev == null || prev == b);
            return prev;
        }
    }

    public static class FetchResult
    implements Serializable {
        private static final long serialVersionUID = 6381334821051653354L;
        public int pc;
        public int opcode;
        public transient Sh2Block block;

        public String toString() {
            return new StringJoiner(", ", FetchResult.class.getSimpleName() + "[", "]").add("pc=" + this.pc).add("opcode=" + this.opcode).add("block=" + String.valueOf(this.block)).toString();
        }
    }

    public static class Sh2Config {
        public static final Sh2Config DEFAULT_CONFIG = new Sh2Config();
        private static final AtomicReference<Sh2Config> instance = new AtomicReference<Sh2Config>(DEFAULT_CONFIG);
        public final boolean prefetchEn;
        public final boolean drcEn;
        public final boolean pollDetectEn;
        public final boolean ignoreDelays;
        public final boolean tasQuirk;

        private Sh2Config() {
            this.tasQuirk = true;
            this.ignoreDelays = false;
            this.pollDetectEn = false;
            this.drcEn = false;
            this.prefetchEn = false;
            LOG.info("Default config: {}", (Object)this);
        }

        public Sh2Config(boolean prefetchEn, boolean drcEn, boolean pollDetectEn, boolean ignoreDelays) {
            this(prefetchEn, drcEn, pollDetectEn, ignoreDelays, 1);
        }

        public Sh2Config(boolean prefetchEn, boolean drcEn, boolean pollDetectEn, boolean ignoreDelays, int tasQuirk) {
            this.prefetchEn = prefetchEn;
            this.drcEn = drcEn;
            this.pollDetectEn = pollDetectEn;
            this.ignoreDelays = ignoreDelays;
            boolean bl = this.tasQuirk = tasQuirk > 0;
            if (instance.compareAndSet(DEFAULT_CONFIG, this)) {
                LOG.info("Using config: {}", (Object)this);
            } else {
                LOG.error("Ignoring config: {}, current: {}", (Object)this, instance);
            }
        }

        public static Sh2Config get() {
            return instance.get();
        }

        public static void reset(Sh2Config config) {
            instance.set(config);
            LOG.warn("Overriding config: {}", (Object)config);
        }

        public String toString() {
            return new StringJoiner(", ", Sh2Config.class.getSimpleName() + "[", "]").add("prefetchEn=" + this.prefetchEn).add("drcEn=" + this.drcEn).add("pollDetectEn=" + this.pollDetectEn).add("ignoreDelays=" + this.ignoreDelays).toString();
        }
    }
}

