/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.drc;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.StringJoiner;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.MdRuntimeData;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.Sh2MMREG;
import s32x.sh2.Sh2;
import s32x.sh2.Sh2Context;
import s32x.sh2.Sh2Debug;
import s32x.sh2.Sh2Helper;
import s32x.sh2.drc.Sh2BlockRecompiler;
import s32x.sh2.drc.Sh2DrcBlockOptimizer;
import s32x.sh2.prefetch.Sh2Prefetch;
import s32x.sh2.prefetch.Sh2Prefetcher;

public class Sh2Block {
    private static final Logger LOG = LogHelper.getLogger(Sh2Block.class.getSimpleName());
    private static final int OPT_THRESHOLD2 = Integer.parseInt(System.getProperty("helios.32x.sh2.drc.stage2.hits", "31"));
    public static final Sh2Block INVALID_BLOCK = new Sh2Block(-1, BufferUtil.CpuDeviceAccess.MASTER);
    public static final int SH2_DRC_MAX_BLOCK_LEN_BYTES = Integer.parseInt(System.getProperty("helios.32x.sh2.drc.maxBlockLen", "32"));
    public static final int MAX_INST_LEN = SH2_DRC_MAX_BLOCK_LEN_BYTES >> 1;
    public static final int CPU_FLAG = 1;
    public static final int CACHE_FETCH_FLAG = 2;
    public static final int NO_JUMP_FLAG = 4;
    public static final int VALID_FLAG = 8;
    public Sh2Prefetcher.Sh2BlockUnit[] inst;
    public Sh2Prefetcher.Sh2BlockUnit curr;
    public int[] prefetchWords;
    public int prefetchPc;
    public int hits;
    public int start;
    public int end;
    public int pcMasked;
    public int prefetchLenWords;
    public int fetchMemAccessDelay;
    public int cyclesConsumed;
    public ByteBuffer fetchBuffer;
    public Sh2Block nextBlock = INVALID_BLOCK;
    public Sh2Prefetch.Sh2DrcContext drcContext;
    public Sh2DrcBlockOptimizer.PollerCtx poller = Sh2DrcBlockOptimizer.UNKNOWN_POLLER;
    public int blockFlags;
    public Sh2DrcBlockOptimizer.PollType pollType = Sh2DrcBlockOptimizer.PollType.UNKNOWN;
    public Runnable stage2Drc;
    public int hashCodeWords;
    private static final boolean verbose = false;

    public Sh2Block(int pc, BufferUtil.CpuDeviceAccess cpu) {
        this.prefetchPc = pc;
        this.blockFlags = cpu.ordinal() | 8;
    }

    public final void runBlock(Sh2 sh2, Sh2MMREG sm) {
        assert (this.prefetchPc != -1);
        assert ((this.blockFlags & 8) > 0);
        if (this.stage2Drc != null) {
            this.stage2Drc.run();
            if (this.drcContext.sh2Ctx.debug) {
                Sh2Debug.drcDebug(this.getCpu(), this.prefetchPc);
            }
            return;
        }
        this.runInterpreter(sh2, sm, this.drcContext.sh2Ctx);
    }

    protected final void runInterpreter(Sh2 sh2, Sh2MMREG sm, Sh2Context ctx) {
        Sh2Prefetcher.Sh2BlockUnit prev = this.curr;
        this.addHit();
        int startCycle = ctx.cycles;
        while (true) {
            sh2.printDebugMaybe(this.curr.opcode);
            this.curr.runnable.run();
            if (this.curr.inst.isBranchDelaySlot() || this.curr.next == null) break;
            this.curr = this.curr.next;
        }
        this.cyclesConsumed = startCycle - ctx.cycles + MdRuntimeData.getCpuDelayExt();
        this.curr = prev;
    }

    public void addHit() {
        ++this.hits;
        if (this.stage2Drc == null && (this.hits + 1 & OPT_THRESHOLD2) == 0) {
            assert (this.inst != null);
            this.stage2();
            if (Sh2Helper.Sh2Config.get().pollDetectEn) {
                Sh2DrcBlockOptimizer.pollDetector(this);
            }
        }
    }

    public void stage1(Sh2Prefetcher.Sh2BlockUnit[] ic) {
        assert (this.inst == null);
        this.inst = ic;
        this.inst[0].next = this.inst.length > 1 ? this.inst[1] : null;
        this.inst[0].pc = this.prefetchPc;
        int lastIdx = ic.length - 1;
        for (int i = 1; i < this.inst.length - 1; ++i) {
            this.inst[i].next = this.inst[i + 1];
            this.inst[i].pc = this.prefetchPc + (i << 1);
            assert (!this.inst[i].inst.isBranch() || this.inst[i].inst.isBranchDelaySlot());
        }
        Sh2Prefetcher.Sh2BlockUnit sbu = this.inst[lastIdx];
        sbu.pc = this.prefetchPc + (lastIdx << 1);
        this.curr = this.inst[0];
        assert (sbu.pc != 0);
        assert (this.inst.length >= MAX_INST_LEN - 1 || sbu.inst.isBranch() || this.inst[Math.max((int)0, (int)(lastIdx - 1))].inst.isBranchDelaySlot() && !sbu.inst.isBranch() || sbu.inst.isIllegal()) : Util.th(sbu.pc) + "," + this.inst.length + "\n" + String.valueOf(this);
    }

    public void stage2() {
        if (Sh2Helper.Sh2Config.get().drcEn) {
            assert (this.drcContext != null);
            this.stage2Drc = Sh2BlockRecompiler.getInstance().createDrcClass(this, this.drcContext);
        }
    }

    public boolean isPollingBlock() {
        return this.pollType.ordinal() > Sh2DrcBlockOptimizer.PollType.NONE.ordinal();
    }

    public void setCacheFetch(boolean val) {
        this.setFlag(2, val);
    }

    public void setNoJump(boolean val) {
        this.setFlag(4, val);
    }

    public boolean isValid() {
        return (this.blockFlags & 8) > 0;
    }

    private void setFlag(int flag, boolean val) {
        this.blockFlags &= ~flag;
        this.blockFlags |= val ? flag : 0;
    }

    public boolean isNoJump() {
        return (this.blockFlags & 4) > 0;
    }

    public boolean isCacheFetch() {
        return (this.blockFlags & 2) > 0;
    }

    public void invalidate() {
        this.blockFlags &= 0xFFFFFFF7;
        this.prefetchPc |= 1;
    }

    public void setValid() {
        this.blockFlags |= 8;
        this.prefetchPc &= 0xFFFFFFFE;
    }

    public BufferUtil.CpuDeviceAccess getCpu() {
        return BufferUtil.CpuDeviceAccess.cdaValues[this.blockFlags & 1];
    }

    public String toString() {
        return new StringJoiner(", ", Sh2Block.class.getSimpleName() + "[", "]").add("inst=" + Arrays.toString(this.inst)).add("curr=" + String.valueOf(this.curr)).add("prefetchWords=" + Arrays.toString(this.prefetchWords)).add("prefetchPc=" + Util.th(this.prefetchPc)).add("hits=" + this.hits).add("start=" + Util.th(this.start)).add("end=" + Util.th(this.end)).add("pcMasked=" + Util.th(this.pcMasked)).add("prefetchLenWords=" + this.prefetchLenWords).add("fetchMemAccessDelay=" + this.fetchMemAccessDelay).add("cyclesConsumed=" + this.cyclesConsumed).add("fetchBuffer=" + String.valueOf(this.fetchBuffer)).add("drcContext=" + String.valueOf(this.drcContext)).add("blockFlags=" + this.blockFlags).add("pollType=" + String.valueOf((Object)this.pollType)).add("stage2Drc=" + String.valueOf(this.stage2Drc)).toString();
    }

    static {
        BufferUtil.assertPowerOf2Minus1("OPT_THRESHOLD2", OPT_THRESHOLD2);
        INVALID_BLOCK.setFlag(8, false);
    }
}

