/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.drc;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import omegadrive.util.FileUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.bus.Sh2Bus;
import s32x.bus.Sh2BusImpl;
import s32x.sh2.drc.Ow2Sh2BlockRecompiler;
import s32x.sh2.drc.Sh2Block;
import s32x.sh2.prefetch.Sh2Prefetch;
import s32x.sh2.prefetch.Sh2Prefetcher;

public class Sh2BlockRecompiler {
    private static final Logger LOG = LogHelper.getLogger(Sh2BlockRecompiler.class.getSimpleName());
    private static final Path drcFolder = Paths.get("./res/drc_" + System.currentTimeMillis(), new String[0]);
    private static final boolean writeClass = false;
    private final OwnClassLoader cl = new OwnClassLoader();
    public static final String drcPackage = Sh2BlockRecompiler.class.getPackageName();
    public static Class<?> memoryClass;
    private static Sh2BlockRecompiler current;
    private String token;
    private InternalSh2BlockRecompiler recompiler = new Ow2Sh2BlockRecompiler();

    public static Sh2BlockRecompiler newInstance(String token) {
        boolean newOne;
        boolean firstOne = current == null;
        boolean bl = newOne = firstOne || Objects.equals(Sh2BlockRecompiler.current.token, token);
        if (newOne) {
            Sh2BlockRecompiler newrec = new Sh2BlockRecompiler();
            newrec.token = token;
            current = newrec;
            LOG.info("New recompiler: {}, with token: {}", (Object)newrec.recompiler.getClass().getName(), (Object)token);
        }
        return current;
    }

    private Sh2BlockRecompiler() {
    }

    public static Sh2BlockRecompiler getInstance() {
        assert (current != null);
        return current;
    }

    public Runnable createDrcClass(Sh2Block block, Sh2Prefetch.Sh2DrcContext drcCtx) {
        Runnable r;
        String blockClass = drcPackage + "." + drcCtx.sh2Ctx.sh2ShortCode + "_" + Util.th(block.prefetchPc) + "_" + Util.th(block.hashCodeWords) + "_" + System.nanoTime();
        memoryClass = drcCtx.memory instanceof Sh2BusImpl ? Sh2BusImpl.class : Sh2Bus.class;
        try {
            byte[] binc = this.recompiler.createClassBinary(block, drcCtx, blockClass, memoryClass);
            this.writeClassMaybe(blockClass, binc);
            Class<?> clazz = this.cl.defineClass(blockClass, binc);
            Object b = clazz.getDeclaredConstructor(int[].class, int[].class, Sh2Prefetch.Sh2DrcContext.class).newInstance(drcCtx.sh2Ctx.registers, block.prefetchWords, drcCtx);
            assert (b instanceof Runnable);
            r = (Runnable)b;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Fatal! ," + blockClass);
        }
        return r;
    }

    public static void setDrcContext(Sh2Prefetch.BytecodeContext ctx, Sh2Prefetcher.Sh2BlockUnit sbu, boolean delaySlot) {
        ctx.opcode = sbu.opcode;
        ctx.pc = sbu.pc;
        ctx.sh2Inst = sbu.inst;
        ctx.delaySlot = delaySlot;
        ctx.delaySlotCtx = null;
    }

    private void writeClassMaybe(String blockClass, byte[] binc) {
    }

    private /* synthetic */ void lambda$writeClassMaybe$0(Path bc, byte[] binc, Path p) {
        this.recompiler.printSource(bc, binc);
        LOG.info("Bytecode Class written: {}", (Object)bc.toAbsolutePath());
        FileUtil.writeFileSafe(p, binc);
        LOG.info("Drc Class written: {}", (Object)p.toAbsolutePath());
    }

    static {
        current = null;
    }

    static interface InternalSh2BlockRecompiler {
        public byte[] createClassBinary(Sh2Block var1, Sh2Prefetch.Sh2DrcContext var2, String var3, Class<?> var4);

        public void printSource(Path var1, byte[] var2);
    }

    public static class OwnClassLoader
    extends ClassLoader {
        public Class<?> defineClass(String name, byte[] b) {
            return this.defineClass(name, b, 0, b.length);
        }
    }
}

