/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.prefetch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import omegadrive.cpu.CpuFastDebug;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.sh2.Sh2Helper;
import s32x.sh2.drc.Sh2Block;

public class PrefetchUtil {
    private static final Logger LOG = LogHelper.getLogger(PrefetchUtil.class.getSimpleName());

    public static void logPcHits(BufferUtil.CpuDeviceAccess cpu) {
        HashMap<Sh2Helper.Sh2PcInfoWrapper, Long> hitMap = new HashMap<Sh2Helper.Sh2PcInfoWrapper, Long>();
        long top10 = 10L;
        Sh2Helper.Sh2PcInfoWrapper[][] pcInfoWrapper = Sh2Helper.getPcInfoWrapper();
        for (int i = 0; i < pcInfoWrapper.length; ++i) {
            for (int j = 0; j < pcInfoWrapper[i].length; ++j) {
                Sh2Helper.Sh2PcInfoWrapper piw = pcInfoWrapper[i][j | cpu.ordinal()];
                if (piw == Sh2Helper.SH2_NOT_VISITED || (long)piw.block.hits < top10) continue;
                hitMap.put(piw, Long.valueOf(piw.block.hits));
                top10 = hitMap.values().stream().sorted().limit(10L).findFirst().orElse(10L);
            }
        }
        List<Map.Entry> l = hitMap.entrySet().stream().sorted((e1, e2) -> Long.compare((Long)e2.getValue(), (Long)e1.getValue())).limit(10L).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        l.forEach(e -> {
            CpuFastDebug.PcInfoWrapper piw = (CpuFastDebug.PcInfoWrapper)e.getKey();
            int pc = piw.area << 24 | piw.pcMasked;
            Sh2Block res = Sh2Block.INVALID_BLOCK;
            assert (res != Sh2Block.INVALID_BLOCK);
            sb.append(String.valueOf((Object)cpu) + " " + Util.th(pc) + "," + String.valueOf(e.getValue()) + ", block: " + Util.th(res.prefetchPc) + "," + String.valueOf((Object)res.pollType) + "," + res.hits + "\n" + String.valueOf(Sh2Helper.toListOfInst(res))).append("\n");
        });
        LOG.info(sb.toString());
    }
}

