/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.prefetch;

import java.nio.ByteBuffer;
import java.util.Arrays;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.MdRuntimeData;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.bus.Sh2Bus;
import s32x.bus.Sh2BusImpl;
import s32x.dict.S32xMemAccessDelay;
import s32x.sh2.Sh2Helper;
import s32x.sh2.Sh2Instructions;
import s32x.sh2.cache.Sh2Cache;
import s32x.sh2.prefetch.Sh2Prefetcher;
import s32x.util.BiosHolder;

public class Sh2PrefetchSimple
implements Sh2Prefetcher {
    private static final Logger LOG = LogHelper.getLogger(Sh2PrefetchSimple.class.getSimpleName());
    private static final boolean SH2_PREFETCH_DEBUG = false;
    public static final int DEFAULT_PREFETCH_LOOKAHEAD = 22;
    public static final int PC_CACHE_AREA_SHIFT = 28;
    private static final boolean verbose = false;
    private final Sh2Bus memory;
    private final Sh2Cache[] cache;
    private final Sh2Helper.Sh2Config sh2Config;
    public final int romSize;
    public final int romMask;
    public final BiosHolder.BiosData[] bios;
    public final ByteBuffer sdram;
    public final ByteBuffer rom;
    public static final PrefetchContext[] prefetchContexts = new PrefetchContext[2];

    public Sh2PrefetchSimple(Sh2BusImpl memory, Sh2Cache[] cache) {
        this.cache = cache;
        this.memory = memory;
        this.romMask = memory.romMask;
        this.romSize = memory.romSize;
        this.sdram = memory.sdram;
        this.rom = memory.rom;
        this.bios = memory.bios;
        this.sh2Config = Sh2Helper.Sh2Config.get();
        Sh2PrefetchSimple.prefetchContexts[0] = new PrefetchContext();
        Sh2PrefetchSimple.prefetchContexts[1] = new PrefetchContext();
    }

    public void doPrefetch(PrefetchContext pctx, int pc, BufferUtil.CpuDeviceAccess cpu) {
        if (!this.sh2Config.prefetchEn) {
            return;
        }
        Sh2Cache sh2Cache = this.cache[cpu.ordinal()];
        boolean isCache = pc >>> 28 == 0;
        pctx.start = pc & 0xFFFFFFF;
        pctx.end = (pc & 0xFFFFFFF) + 44;
        switch (pc >> 24) {
            case 6: 
            case 38: {
                pctx.start = Math.max(0, pctx.start & 0x3FFFF);
                pctx.end = Math.min(262143, pctx.end & 0x3FFFF);
                pctx.pcMasked = pc & 0x3FFFF;
                pctx.memAccessDelay = 6;
                pctx.buf = this.sdram;
                break;
            }
            case 2: 
            case 34: {
                pctx.start = Math.max(0, pctx.start) & this.romMask;
                pctx.end = Math.min(this.romSize - 1, pctx.end & this.romMask);
                pctx.pcMasked = pc & this.romMask;
                pctx.memAccessDelay = 0;
                pctx.buf = this.rom;
                break;
            }
            case 0: 
            case 32: {
                BiosHolder.BiosData bd = this.bios[cpu.ordinal()];
                pctx.buf = bd.buffer;
                pctx.start = Math.max(0, pctx.start);
                pctx.end &= bd.padMask;
                pctx.pcMasked = pc;
                pctx.memAccessDelay = 5;
                break;
            }
            default: {
                if (pc >>> 28 == 12) {
                    int twoWay = this.cache[cpu.ordinal()].getCacheContext().twoWay;
                    int mask = 4095 >> twoWay;
                    pctx.start = Math.max(0, pctx.start) & mask;
                    pctx.memAccessDelay = 4;
                    pctx.buf = this.cache[cpu.ordinal()].getDataArray();
                    pctx.pcMasked = pc & mask;
                    break;
                }
                LOG.error("{} Unhandled prefetch: {}", (Object)cpu, (Object)Util.th(pc));
                throw new RuntimeException("Unhandled prefetch: " + Util.th(pc));
            }
        }
        pctx.prefetchPc = pc;
        boolean outNext = false;
        int cpc = (pc & 0xFFFFFFF) - (pctx.pcMasked - pctx.start);
        int bytePos = pctx.start;
        while (bytePos < pctx.end) {
            int opc;
            int w = bytePos - pctx.pcMasked >> 1;
            pctx.prefetchWords[w] = opc = isCache ? sh2Cache.readDirect(cpc, Size.WORD) : pctx.buf.getShort(bytePos) & 0xFFFF;
            Sh2Instructions.Sh2BaseInstruction instType = Sh2Instructions.sh2OpcodeMap[opc];
            if (instType.isBranchDelaySlot()) {
                outNext = true;
            } else if (instType.isBranch() || outNext) {
                if (outNext) assert (!Sh2Instructions.instOpcodeMap[opc].inst.isIllegalSlot()) : Sh2Instructions.instOpcodeMap[opc].inst;
                pctx.end = bytePos + 2;
                break;
            }
            bytePos += 2;
            cpc += 2;
        }
        if (isCache) {
            sh2Cache.cacheMemoryRead(pc, Size.WORD);
        }
        pctx.pfMaxIndex = pctx.end - 2 - pctx.start >> 1;
        pctx.dirty = false;
    }

    public void prefetch(int pc, BufferUtil.CpuDeviceAccess cpu) {
        this.doPrefetch(prefetchContexts[cpu.ordinal()], pc, cpu);
        assert (prefetchContexts[cpu.ordinal()] != null);
    }

    @Override
    public void fetch(Sh2Helper.FetchResult ft, BufferUtil.CpuDeviceAccess cpu) {
        ft.opcode = this.fetch(ft.pc, cpu);
    }

    public int fetch(int pc, BufferUtil.CpuDeviceAccess cpu) {
        assert (cpu == MdRuntimeData.getAccessTypeExt());
        if (!this.sh2Config.prefetchEn) {
            return this.memory.read(pc, Size.WORD) & 0xFFFF;
        }
        PrefetchContext pctx = prefetchContexts[cpu.ordinal()];
        int pcDeltaWords = pc - pctx.prefetchPc >> 1;
        if (pctx.dirty || pcDeltaWords < 0 || pcDeltaWords > pctx.pfMaxIndex) {
            this.prefetch(pc, cpu);
            pcDeltaWords = 0;
            pctx = prefetchContexts[cpu.ordinal()];
        } else {
            boolean isCache;
            boolean bl = isCache = pc >>> 28 == 0;
            if (isCache && this.cache[cpu.ordinal()].getCacheContext().cacheEn > 0) {
                int cached = this.cache[cpu.ordinal()].cacheMemoryRead(pc, Size.WORD) & 0xFFFF;
                assert (cached == pctx.prefetchWords[pcDeltaWords]) : Util.th(cached) + "," + Util.th(pctx.prefetchWords[pcDeltaWords]);
            }
        }
        S32xMemAccessDelay.addReadCpuDelay(pctx.memAccessDelay);
        int pres = pctx.prefetchWords[pcDeltaWords];
        return pres;
    }

    @Override
    public int fetchDelaySlot(int pc, Sh2Helper.FetchResult ft, BufferUtil.CpuDeviceAccess cpu) {
        int res;
        if (!this.sh2Config.prefetchEn) {
            assert (cpu == MdRuntimeData.getAccessTypeExt());
            return this.memory.read(pc, Size.WORD) & 0xFFFF;
        }
        PrefetchContext pctx = prefetchContexts[cpu.ordinal()];
        int pcDeltaWords = pc - pctx.prefetchPc >> 1;
        if (!pctx.dirty && pcDeltaWords >= 0 && pcDeltaWords <= pctx.pfMaxIndex) {
            S32xMemAccessDelay.addReadCpuDelay(pctx.memAccessDelay);
            res = pctx.prefetchWords[pcDeltaWords];
        } else {
            res = this.memory.read(pc, Size.WORD) & 0xFFFF;
        }
        return res;
    }

    @Override
    public void dataWrite(BufferUtil.CpuDeviceAccess cpuWrite, int addr, int val, Size size) {
        if (!this.sh2Config.prefetchEn) {
            return;
        }
        boolean isCacheArray = addr >>> 24 == 192;
        boolean isWriteThrough = addr >>> 24 == 32;
        for (int i = 0; i <= BufferUtil.CpuDeviceAccess.SLAVE.ordinal(); ++i) {
            boolean isCacheEnabled;
            if (isCacheArray && i != cpuWrite.ordinal()) continue;
            this.checkPrefetch(cpuWrite, BufferUtil.CpuDeviceAccess.cdaValues[i], addr, val, size);
            boolean bl = isCacheEnabled = this.cache[i].getCacheContext().cacheEn > 0;
            if (isCacheEnabled) continue;
            int otherAddr = isWriteThrough ? addr & 0xFFFFFFF : addr | 0x20000000;
            this.checkPrefetch(cpuWrite, BufferUtil.CpuDeviceAccess.cdaValues[i], otherAddr, val, size);
        }
    }

    public void invalidateAllPrefetch(BufferUtil.CpuDeviceAccess cpu) {
        Sh2PrefetchSimple.prefetchContexts[cpu.ordinal()].dirty = true;
    }

    private void checkPrefetch(BufferUtil.CpuDeviceAccess cpuWrite, BufferUtil.CpuDeviceAccess cpu, int writeAddr, int val, Size size) {
        PrefetchContext p = prefetchContexts[cpu.ordinal()];
        int start = p.prefetchPc;
        int end = start + (p.pfMaxIndex << 1);
        if (writeAddr >= start && writeAddr <= end) {
            p.dirty = true;
        }
    }

    @Override
    public void invalidateCachePrefetch(Sh2Cache.CacheInvalidateContext ctx) {
        boolean isCacheAddress;
        PrefetchContext p = prefetchContexts[ctx.cpu.ordinal()];
        if (p.dirty) {
            return;
        }
        boolean bl = isCacheAddress = ctx.force || ctx.cacheReadAddr >>> 28 == 0;
        assert (isCacheAddress) : String.valueOf((Object)ctx.cpu) + "," + Util.th(ctx.cacheReadAddr);
        int start = p.prefetchPc;
        int end = start + (p.pfMaxIndex << 1);
        int lineStart = ctx.prevCacheAddr;
        int lineEnd = lineStart + 16;
        if (ctx.force || lineEnd >= start && lineStart <= end) {
            p.dirty = true;
        }
    }

    public static class PrefetchContext {
        public final int[] prefetchWords;
        public int start;
        public int end;
        public int prefetchPc;
        public int pcMasked;
        public int hits;
        public int pfMaxIndex;
        public int memAccessDelay;
        public boolean dirty;
        public ByteBuffer buf;

        public PrefetchContext() {
            this(22);
        }

        public PrefetchContext(int lookahead) {
            this.prefetchWords = new int[lookahead];
        }

        public String toString() {
            return "PrefetchContext{, start=" + Util.th(this.start) + ", end=" + Util.th(this.end) + ", prefetchPc=" + Util.th(this.prefetchPc) + ", pcMasked=" + Util.th(this.pcMasked) + "}";
        }

        public String toStringVerbose() {
            return String.valueOf(this) + "\n" + Arrays.toString(this.prefetchWords);
        }
    }
}

