/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.prefetch;

import java.util.StringJoiner;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import org.slf4j.Logger;
import s32x.sh2.Sh2Helper;
import s32x.sh2.Sh2Instructions;
import s32x.sh2.cache.Sh2Cache;

public interface Sh2Prefetcher {
    public static final Logger LOG = LogHelper.getLogger(Sh2Prefetcher.class.getSimpleName());
    public static final boolean verbose = false;

    public void fetch(Sh2Helper.FetchResult var1, BufferUtil.CpuDeviceAccess var2);

    public int fetchDelaySlot(int var1, Sh2Helper.FetchResult var2, BufferUtil.CpuDeviceAccess var3);

    public void invalidateCachePrefetch(Sh2Cache.CacheInvalidateContext var1);

    default public void dataWrite(BufferUtil.CpuDeviceAccess cpu, int addr, int val, Size size) {
    }

    default public void newFrame() {
    }

    public static class Stats {
        static String format = "%s pfTot: %d, pfMissPerc: %f, pfDsMissPerc: %f";
        public long pfMiss;
        public long pfTotal;
        public long pfDsMiss;
        private final BufferUtil.CpuDeviceAccess cpu;

        public Stats(BufferUtil.CpuDeviceAccess cpu) {
            this.cpu = cpu;
        }

        public String toString() {
            return String.format(format, new Object[]{this.cpu, this.pfTotal, 1.0 * (double)this.pfMiss / (double)this.pfTotal, 1.0 * (double)this.pfDsMiss / (double)this.pfTotal});
        }

        public void addMiss() {
            if ((++this.pfMiss & 0xFFL) == 0L) {
                LOG.info(this.toString());
            }
        }

        public void addDelaySlotMiss() {
            this.addMiss();
            ++this.pfDsMiss;
        }
    }

    public static class Sh2BlockUnit
    extends Sh2Instructions.Sh2InstructionWrapper {
        public Sh2BlockUnit next;
        public int pc;

        public Sh2BlockUnit(Sh2Instructions.Sh2InstructionWrapper i) {
            super(i.opcode, i.inst, i.runnable);
        }

        @Override
        public String toString() {
            return new StringJoiner(", ", Sh2BlockUnit.class.getSimpleName() + "[", "]").add("pc=" + this.pc).add("inst=" + String.valueOf((Object)this.inst)).add("opcode=" + this.opcode).toString();
        }
    }
}

